/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.browser.manual.errorlog;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.SuperDataset;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@SuperDataset
@Stream(name="browser_error_log", scopeId=34, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="timestamp")
public class BrowserErrorLogRecord
extends Record {
    public static final String INDEX_NAME = "browser_error_log";
    public static final String UNIQUE_ID = "unique_id";
    public static final String SERVICE_ID = "service_id";
    public static final String SERVICE_VERSION_ID = "service_version_id";
    public static final String PAGE_PATH_ID = "page_path_id";
    public static final String TIMESTAMP = "timestamp";
    public static final String ERROR_CATEGORY = "error_category";
    public static final String DATA_BINARY = "data_binary";
    @Column(name="unique_id")
    private String uniqueId;
    @Column(name="service_id")
    @BanyanDB.SeriesID(index=0)
    private String serviceId;
    @Column(name="service_version_id", length=512)
    private String serviceVersionId;
    @Column(name="page_path_id", length=512)
    private String pagePathId;
    @Column(name="timestamp")
    private long timestamp;
    @Column(name="error_category")
    private int errorCategory;
    @Column(name="data_binary")
    private byte[] dataBinary;

    @Override
    public StorageID id() {
        return new StorageID().append(UNIQUE_ID, this.uniqueId);
    }

    @Generated
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setServiceVersionId(String serviceVersionId) {
        this.serviceVersionId = serviceVersionId;
    }

    @Generated
    public String getServiceVersionId() {
        return this.serviceVersionId;
    }

    @Generated
    public void setPagePathId(String pagePathId) {
        this.pagePathId = pagePathId;
    }

    @Generated
    public String getPagePathId() {
        return this.pagePathId;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setErrorCategory(int errorCategory) {
        this.errorCategory = errorCategory;
    }

    @Generated
    public int getErrorCategory() {
        return this.errorCategory;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    public static class Builder
    implements StorageBuilder<BrowserErrorLogRecord> {
        @Override
        public BrowserErrorLogRecord storage2Entity(Convert2Entity converter) {
            BrowserErrorLogRecord record = new BrowserErrorLogRecord();
            record.setUniqueId((String)converter.get(BrowserErrorLogRecord.UNIQUE_ID));
            record.setServiceId((String)converter.get(BrowserErrorLogRecord.SERVICE_ID));
            record.setServiceVersionId((String)converter.get(BrowserErrorLogRecord.SERVICE_VERSION_ID));
            record.setPagePathId((String)converter.get(BrowserErrorLogRecord.PAGE_PATH_ID));
            record.setTimestamp(((Number)converter.get(BrowserErrorLogRecord.TIMESTAMP)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            record.setErrorCategory(((Number)converter.get(BrowserErrorLogRecord.ERROR_CATEGORY)).intValue());
            record.setDataBinary(converter.getBytes(BrowserErrorLogRecord.DATA_BINARY));
            return record;
        }

        @Override
        public void entity2Storage(BrowserErrorLogRecord storageData, Convert2Storage converter) {
            converter.accept(BrowserErrorLogRecord.UNIQUE_ID, storageData.getUniqueId());
            converter.accept(BrowserErrorLogRecord.SERVICE_ID, storageData.getServiceId());
            converter.accept(BrowserErrorLogRecord.SERVICE_VERSION_ID, storageData.getServiceVersionId());
            converter.accept(BrowserErrorLogRecord.PAGE_PATH_ID, storageData.getPagePathId());
            converter.accept(BrowserErrorLogRecord.TIMESTAMP, storageData.getTimestamp());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept(BrowserErrorLogRecord.ERROR_CATEGORY, storageData.getErrorCategory());
            converter.accept(BrowserErrorLogRecord.DATA_BINARY, storageData.getDataBinary());
        }
    }
}

