/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.worker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.data.MergableBufferedData;
import org.apache.skywalking.oap.server.core.analysis.data.ReadWriteSafeCache;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricStreamKind;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsSessionCache;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsTransWorker;
import org.apache.skywalking.oap.server.core.analysis.worker.PersistenceWorker;
import org.apache.skywalking.oap.server.core.exporter.ExportEvent;
import org.apache.skywalking.oap.server.core.status.BootingStatus;
import org.apache.skywalking.oap.server.core.status.ClusterStatus;
import org.apache.skywalking.oap.server.core.status.ServerStatusService;
import org.apache.skywalking.oap.server.core.status.ServerStatusWatcher;
import org.apache.skywalking.oap.server.core.storage.IMetricsDAO;
import org.apache.skywalking.oap.server.core.storage.SessionCacheCallback;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.worker.AbstractWorker;
import org.apache.skywalking.oap.server.library.client.request.PrepareRequest;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.BulkConsumePool;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.ConsumerPoolFactory;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsPersistentWorker
extends PersistenceWorker<Metrics>
implements ServerStatusWatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsPersistentWorker.class);
    private final Model model;
    private final MetricsSessionCache sessionCache;
    private final IMetricsDAO metricsDAO;
    private final Optional<AbstractWorker<Metrics>> nextAlarmWorker;
    private final Optional<AbstractWorker<ExportEvent>> nextExportWorker;
    private final DataCarrier<Metrics> dataCarrier;
    private final Optional<MetricsTransWorker> transWorker;
    private final boolean supportUpdate;
    private CounterMetrics aggregationCounter;
    private CounterMetrics readMetricsCounter;
    private CounterMetrics cachedMetricsCounter;
    private int persistentCounter;
    private int persistentMod;
    private int metricsDataTTL;
    private final ServerStatusService serverStatusService;
    private volatile long timeOfLatestStabilitySts = 0L;

    MetricsPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, IMetricsDAO metricsDAO, AbstractWorker<Metrics> nextAlarmWorker, AbstractWorker<ExportEvent> nextExportWorker, MetricsTransWorker transWorker, boolean supportUpdate, long storageSessionTimeout, int metricsDataTTL, MetricStreamKind kind) {
        super(moduleDefineHolder, new ReadWriteSafeCache(new MergableBufferedData(), new MergableBufferedData()));
        this.model = model;
        this.sessionCache = new MetricsSessionCache(storageSessionTimeout);
        this.metricsDAO = metricsDAO;
        this.nextAlarmWorker = Optional.ofNullable(nextAlarmWorker);
        this.nextExportWorker = Optional.ofNullable(nextExportWorker);
        this.transWorker = Optional.ofNullable(transWorker);
        this.supportUpdate = supportUpdate;
        this.persistentCounter = 0;
        this.persistentMod = 1;
        this.metricsDataTTL = metricsDataTTL;
        String name = "METRICS_L2_AGGREGATION";
        int size = BulkConsumePool.Creator.recommendMaxSize() / 8;
        if (size == 0) {
            size = 1;
        }
        BulkConsumePool.Creator creator = new BulkConsumePool.Creator(name, size, 20L);
        try {
            ConsumerPoolFactory.INSTANCE.createIfAbsent(name, (Callable)creator);
        }
        catch (Exception e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        int bufferSize = 2000;
        if (MetricStreamKind.MAL == kind) {
            bufferSize = 1000;
        }
        this.dataCarrier = new DataCarrier("MetricsPersistentWorker." + model.getName(), name, 1, bufferSize);
        this.dataCarrier.consume(ConsumerPoolFactory.INSTANCE.get(name), (IConsumer)new PersistentConsumer());
        MetricsCreator metricsCreator = (MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class);
        this.aggregationCounter = metricsCreator.createCounter("metrics_aggregation", "The number of rows in aggregation", new MetricsTag.Keys(new String[]{"metricName", "level", "dimensionality"}), new MetricsTag.Values(new String[]{model.getName(), "2", model.getDownsampling().getName()}));
        this.readMetricsCounter = metricsCreator.createCounter("metrics_persistent_cache", "The counter of metrics status, new or cached.", new MetricsTag.Keys(new String[]{"status"}), new MetricsTag.Values(new String[]{"new"}));
        this.cachedMetricsCounter = metricsCreator.createCounter("metrics_persistent_cache", "The counter of metrics status, new or cached.", new MetricsTag.Keys(new String[]{"status"}), new MetricsTag.Values(new String[]{"cached"}));
        this.serverStatusService = (ServerStatusService)moduleDefineHolder.find("core").provider().getService(ServerStatusService.class);
        if (model.getDownsampling().equals((Object)DownSampling.Minute)) {
            this.serverStatusService.registerWatcher(this);
        }
    }

    MetricsPersistentWorker(ModuleDefineHolder moduleDefineHolder, Model model, IMetricsDAO metricsDAO, boolean supportUpdate, long storageSessionTimeout, int metricsDataTTL, MetricStreamKind kind) {
        this(moduleDefineHolder, model, metricsDAO, null, null, null, supportUpdate, storageSessionTimeout, metricsDataTTL, kind);
        this.sessionCache.setTimeoutThreshold(storageSessionTimeout * 4L);
        this.persistentMod = 4;
    }

    @Override
    public void in(Metrics metrics) {
        this.aggregationCounter.inc();
        this.dataCarrier.produce((Object)metrics);
    }

    @Override
    public List<PrepareRequest> buildBatchRequests() {
        if (this.persistentCounter++ % this.persistentMod != 0) {
            return Collections.emptyList();
        }
        List lastCollection = this.getCache().read();
        long start = System.currentTimeMillis();
        if (lastCollection.size() == 0) {
            return Collections.emptyList();
        }
        int maxBatchGetSize = 2000;
        int batchSize = Math.min(maxBatchGetSize, lastCollection.size());
        ArrayList<Metrics> metricsList = new ArrayList<Metrics>();
        ArrayList<PrepareRequest> prepareRequests = new ArrayList<PrepareRequest>(lastCollection.size());
        for (Metrics data : lastCollection) {
            this.transWorker.ifPresent(metricsTransWorker -> metricsTransWorker.in(data));
            metricsList.add(data);
            if (metricsList.size() != batchSize) continue;
            this.prepareFlushDataToStorage(metricsList, prepareRequests);
        }
        if (metricsList.size() > 0) {
            this.prepareFlushDataToStorage(metricsList, prepareRequests);
        }
        if (prepareRequests.size() > 0) {
            log.debug("prepare batch requests for model {}, took time: {}, size: {}", new Object[]{this.model.getName(), System.currentTimeMillis() - start, prepareRequests.size()});
        }
        return prepareRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareFlushDataToStorage(List<Metrics> metricsList, List<PrepareRequest> prepareRequests) {
        try {
            this.loadFromStorage(metricsList);
            long timestamp = System.currentTimeMillis();
            for (Metrics metrics : metricsList) {
                Metrics cachedMetrics = this.sessionCache.get(metrics);
                if (cachedMetrics != null) {
                    boolean isAbandoned;
                    cachedMetrics.setLastUpdateTimestamp(timestamp);
                    if (!this.supportUpdate) continue;
                    boolean bl = isAbandoned = !cachedMetrics.combine(metrics);
                    if (isAbandoned) continue;
                    cachedMetrics.calculate();
                    prepareRequests.add((PrepareRequest)this.metricsDAO.prepareBatchUpdate(this.model, cachedMetrics, new SessionCacheCallback(this.sessionCache, cachedMetrics)));
                    this.nextWorker(cachedMetrics);
                } else {
                    metrics.calculate();
                    prepareRequests.add((PrepareRequest)this.metricsDAO.prepareBatchInsert(this.model, metrics, new SessionCacheCallback(this.sessionCache, metrics)));
                    this.nextWorker(metrics);
                    metrics.setLastUpdateTimestamp(timestamp);
                }
                this.nextExportWorker.ifPresent(exportEvenWorker -> exportEvenWorker.in(new ExportEvent(metrics, ExportEvent.EventType.INCREMENT)));
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        finally {
            metricsList.clear();
        }
    }

    private void nextWorker(Metrics metrics) {
        this.nextAlarmWorker.ifPresent(nextAlarmWorker -> nextAlarmWorker.in(metrics));
        this.nextExportWorker.ifPresent(nextExportWorker -> nextExportWorker.in(new ExportEvent(metrics, ExportEvent.EventType.TOTAL)));
    }

    private void loadFromStorage(List<Metrics> metrics) {
        long currentTimeMillis = System.currentTimeMillis();
        try {
            List<Metrics> notInCacheMetrics = metrics.stream().filter(m -> {
                Metrics cachedValue = this.requireInitialization((Metrics)m);
                if (cachedValue == null) {
                    return true;
                }
                if (!this.model.isTimeRelativeID() && this.metricsDAO.isExpiredCache(this.model, cachedValue, currentTimeMillis, this.metricsDataTTL)) {
                    this.sessionCache.remove((Metrics)m);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            this.readMetricsCounter.inc((double)notInCacheMetrics.size());
            this.cachedMetricsCounter.inc((double)(metrics.size() - notInCacheMetrics.size()));
            if (notInCacheMetrics.isEmpty()) {
                return;
            }
            this.metricsDAO.multiGet(this.model, notInCacheMetrics).forEach(m -> {
                m.setLastUpdateTimestamp(currentTimeMillis);
                this.sessionCache.put((Metrics)m);
            });
        }
        catch (Exception e) {
            log.error("Failed to load metrics for merging", (Throwable)e);
        }
    }

    @Override
    public void endOfRound() {
        this.sessionCache.removeExpired();
    }

    private Metrics requireInitialization(Metrics metrics) {
        Metrics cached = this.sessionCache.get(metrics);
        if (cached != null) {
            return cached;
        }
        if (!this.model.isTimeRelativeID()) {
            return null;
        }
        if (this.timeOfLatestStabilitySts > 0L && metrics.getTimeBucket() > this.timeOfLatestStabilitySts && cached == null) {
            return metrics;
        }
        return null;
    }

    @Override
    public void onServerBooted(BootingStatus bootingStatus) {
        this.timeOfLatestStabilitySts = TimeBucket.getMinuteTimeBucket(bootingStatus.getUptime());
    }

    @Override
    public void onClusterRebalanced(ClusterStatus clusterStatus) {
        this.timeOfLatestStabilitySts = TimeBucket.getMinuteTimeBucket(clusterStatus.getRebalancedTime());
    }

    private class PersistentConsumer
    implements IConsumer<Metrics> {
        private PersistentConsumer() {
        }

        public void consume(List<Metrics> data) {
            MetricsPersistentWorker.this.onWork(data);
        }

        public void onError(List<Metrics> data, Throwable t) {
            log.error(t.getMessage(), t);
        }
    }
}

