/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Expression;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.MetricsFunction;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;

@MetricsFunction(functionName="rate")
public abstract class RateMetrics
extends Metrics
implements IntValueHolder {
    protected static final String DENOMINATOR = "denominator";
    protected static final String NUMERATOR = "numerator";
    protected static final String PERCENTAGE = "percentage";
    @Column(name="denominator")
    @BanyanDB.MeasureField
    private long denominator;
    @Column(name="percentage", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    @BanyanDB.MeasureField
    private int percentage;
    @Column(name="numerator")
    @BanyanDB.MeasureField
    private long numerator;

    @Entrance
    public final void combine(@Expression boolean isNumerator, @Expression boolean isDenominator) {
        if (isNumerator) {
            ++this.numerator;
        }
        if (isDenominator) {
            ++this.denominator;
        }
    }

    @Override
    public final boolean combine(Metrics metrics) {
        this.denominator += ((RateMetrics)metrics).denominator;
        this.numerator += ((RateMetrics)metrics).numerator;
        return true;
    }

    @Override
    public void calculate() {
        if (this.denominator == 0L) {
            return;
        }
        this.percentage = (int)(this.numerator * 10000L / this.denominator);
    }

    @Override
    public int getValue() {
        return this.percentage;
    }

    @Generated
    public long getDenominator() {
        return this.denominator;
    }

    @Generated
    public void setDenominator(long denominator) {
        this.denominator = denominator;
    }

    @Generated
    public int getPercentage() {
        return this.percentage;
    }

    @Generated
    public void setPercentage(int percentage) {
        this.percentage = percentage;
    }

    @Generated
    public long getNumerator() {
        return this.numerator;
    }

    @Generated
    public void setNumerator(long numerator) {
        this.numerator = numerator;
    }
}

