/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@ScopeDeclaration(id=43, name="Event")
@Stream(name="events", scopeId=43, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=true)
public class Event
extends Metrics {
    public static final String INDEX_NAME = "events";
    public static final String UUID = "uuid";
    public static final String SERVICE = "service";
    public static final String SERVICE_INSTANCE = "service_instance";
    public static final String ENDPOINT = "endpoint";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String MESSAGE = "message";
    public static final String PARAMETERS = "parameters";
    public static final String START_TIME = "start_time";
    public static final String END_TIME = "end_time";
    public static final String LAYER = "layer";
    private static final int PARAMETER_MAX_LENGTH = 2000;
    @Column(name="uuid")
    @BanyanDB.SeriesID(index=0)
    private String uuid;
    @Column(name="service")
    private String service;
    @Column(name="service_instance")
    private String serviceInstance;
    @Column(name="endpoint")
    private String endpoint;
    @Column(name="name")
    private String name;
    @Column(name="type")
    private String type;
    @Column(name="message")
    private String message;
    @Column(name="parameters", storageOnly=true, length=2000)
    private String parameters;
    @Column(name="start_time")
    private long startTime;
    @Column(name="end_time")
    private long endTime;
    @Column(name="layer")
    private Layer layer;

    @Override
    protected StorageID id0() {
        return new StorageID().append(UUID, this.getUuid());
    }

    @Override
    public boolean combine(Metrics metrics) {
        Event event = (Event)metrics;
        if (this.getTimeBucket() <= 0L) {
            if (event.getStartTime() > 0L) {
                this.setTimeBucket(TimeBucket.getMinuteTimeBucket(event.getStartTime()));
            } else if (event.getEndTime() > 0L) {
                this.setTimeBucket(TimeBucket.getMinuteTimeBucket(event.getEndTime()));
            }
        }
        if (this.getStartTime() <= 0L && event.getStartTime() > 0L) {
            this.setStartTime(event.getStartTime());
        }
        if (event.getEndTime() > 0L) {
            this.setEndTime(event.getEndTime());
        }
        if (StringUtil.isNotBlank((String)event.getType())) {
            this.setType(event.getType());
        }
        if (StringUtil.isNotBlank((String)event.getMessage())) {
            this.setMessage(event.getMessage());
        }
        if (StringUtil.isNotBlank((String)event.getParameters())) {
            this.setParameters(event.getParameters());
        }
        return true;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters == null || parameters.length() <= 2000 ? parameters : parameters.substring(0, 2000);
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setUuid(remoteData.getDataStrings(0));
        this.setService(remoteData.getDataStrings(1));
        this.setServiceInstance(remoteData.getDataStrings(2));
        this.setEndpoint(remoteData.getDataStrings(3));
        this.setName(remoteData.getDataStrings(4));
        this.setType(remoteData.getDataStrings(5));
        this.setMessage(remoteData.getDataStrings(6));
        this.setParameters(remoteData.getDataStrings(7));
        this.setStartTime(remoteData.getDataLongs(0));
        this.setEndTime(remoteData.getDataLongs(1));
        this.setTimeBucket(remoteData.getDataLongs(2));
        this.setLayer(Layer.valueOf(remoteData.getDataIntegers(0)));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.getUuid());
        builder.addDataStrings(this.getService());
        builder.addDataStrings(this.getServiceInstance());
        builder.addDataStrings(this.getEndpoint());
        builder.addDataStrings(this.getName());
        builder.addDataStrings(this.getType());
        builder.addDataStrings(this.getMessage());
        builder.addDataStrings(Strings.nullToEmpty((String)this.getParameters()));
        builder.addDataLongs(this.getStartTime());
        builder.addDataLongs(this.getEndTime());
        builder.addDataLongs(this.getTimeBucket());
        builder.addDataIntegers(this.getLayer().value());
        return builder;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getService() {
        return this.service;
    }

    @Generated
    public String getServiceInstance() {
        return this.serviceInstance;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getParameters() {
        return this.parameters;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Layer getLayer() {
        return this.layer;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setService(String service) {
        this.service = service;
    }

    @Generated
    public void setServiceInstance(String serviceInstance) {
        this.serviceInstance = serviceInstance;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        return result;
    }

    public static class Builder
    implements StorageBuilder<Event> {
        @Override
        public Event storage2Entity(Convert2Entity converter) {
            Event record = new Event();
            record.setUuid((String)converter.get(Event.UUID));
            record.setService((String)converter.get(Event.SERVICE));
            record.setServiceInstance((String)converter.get(Event.SERVICE_INSTANCE));
            record.setEndpoint((String)converter.get(Event.ENDPOINT));
            record.setName((String)converter.get(Event.NAME));
            record.setType((String)converter.get(Event.TYPE));
            record.setMessage((String)converter.get(Event.MESSAGE));
            record.setParameters((String)converter.get(Event.PARAMETERS));
            record.setStartTime(((Number)converter.get(Event.START_TIME)).longValue());
            record.setEndTime(((Number)converter.get(Event.END_TIME)).longValue());
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            if (converter.get(Event.LAYER) != null) {
                record.setLayer(Layer.valueOf(((Number)converter.get(Event.LAYER)).intValue()));
            }
            return record;
        }

        @Override
        public void entity2Storage(Event storageData, Convert2Storage converter) {
            converter.accept(Event.UUID, storageData.getUuid());
            converter.accept(Event.SERVICE, storageData.getService());
            converter.accept(Event.SERVICE_INSTANCE, storageData.getServiceInstance());
            converter.accept(Event.ENDPOINT, storageData.getEndpoint());
            converter.accept(Event.NAME, storageData.getName());
            converter.accept(Event.TYPE, storageData.getType());
            converter.accept(Event.MESSAGE, storageData.getMessage());
            converter.accept(Event.PARAMETERS, storageData.getParameters());
            converter.accept(Event.START_TIME, storageData.getStartTime());
            converter.accept(Event.END_TIME, storageData.getEndTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
            Layer layer = storageData.getLayer();
            converter.accept(Event.LAYER, layer != null ? layer.value() : Layer.UNDEFINED.value());
        }
    }
}

