/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;

public class DataTable
implements StorageDataComplexObject<DataTable> {
    private HashMap<String, Long> data;

    public DataTable() {
        this.data = new HashMap();
    }

    public DataTable(int initialCapacity) {
        this.data = new HashMap(initialCapacity);
    }

    public DataTable(String data) {
        this();
        this.toObject(data);
    }

    public Long get(String key) {
        return this.data.get(key);
    }

    public void put(String key, Long value) {
        this.data.put(key, value);
    }

    public void valueAccumulation(String key, Long value) {
        Long element = this.data.get(key);
        element = element == null ? value : Long.valueOf(element + value);
        this.data.put(key, element);
    }

    public long sumOfValues() {
        return this.data.values().stream().mapToLong(element -> element).sum();
    }

    public boolean keysEqual(DataTable that) {
        if (this.data.keySet().size() != that.data.keySet().size()) {
            return false;
        }
        return this.data.keySet().equals(that.data.keySet());
    }

    public List<String> sortedKeys(Comparator<String> keyComparator) {
        return this.data.keySet().stream().sorted(keyComparator).collect(Collectors.toList());
    }

    public List<Long> sortedValues(Comparator<String> keyComparator) {
        List<String> collect = this.data.keySet().stream().sorted(keyComparator).collect(Collectors.toList());
        ArrayList<Long> values = new ArrayList<Long>(collect.size());
        collect.forEach(key -> values.add(this.data.get(key)));
        return values;
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }

    public boolean hasKey(String key) {
        return this.data.containsKey(key);
    }

    public int size() {
        return this.data.size();
    }

    @Override
    public String toStorageData() {
        StringBuilder builder = new StringBuilder();
        this.data.forEach((key, value) -> {
            if (builder.length() != 0) {
                builder.append("|");
            }
            builder.append((String)key).append(",").append(value);
        });
        return builder.toString();
    }

    @Override
    public void toObject(String data) {
        String[] keyValues;
        for (String keyValue : keyValues = data.split("\\|")) {
            String[] keyValuePair = keyValue.split(",");
            if (keyValuePair.length != 2) continue;
            this.data.put(keyValuePair[0], Long.parseLong(keyValuePair[1]));
        }
    }

    @Override
    public void copyFrom(DataTable source) {
        this.append(source);
    }

    public DataTable append(DataTable dataTable) {
        dataTable.data.forEach((key, value) -> {
            Long current = this.data.get(key);
            current = current == null ? value : Long.valueOf(current + value);
            this.data.put((String)key, current);
        });
        return this;
    }

    @Generated
    public String toString() {
        return "DataTable(data=" + this.data + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable)) {
            return false;
        }
        DataTable other = (DataTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashMap<String, Long> this$data = this.data;
        HashMap<String, Long> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashMap<String, Long> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }
}

