/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.sumpermin;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.Entrance;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.SourceFrom;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@MeterFunction(functionName="sumPerMin")
public abstract class SumPerMinFunction
extends Meter
implements AcceptableValue<Long>,
LongValueHolder {
    protected static final String VALUE = "value";
    protected static final String TOTAL = "total";
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @Column(name="value", dataType=Column.ValueDataType.COMMON_VALUE, function=Function.Avg)
    @BanyanDB.MeasureField
    private long value;
    @Column(name="total", storageOnly=true)
    @BanyanDB.MeasureField
    private long total;

    @Entrance
    public final void combine(@SourceFrom long value) {
        this.total += value;
    }

    @Override
    public boolean combine(Metrics metrics) {
        SumPerMinFunction sumPerMinFunction = (SumPerMinFunction)metrics;
        this.combine(sumPerMinFunction.getTotal());
        return true;
    }

    @Override
    public void calculate() {
        this.setValue(this.total / this.getDurationInMinute());
    }

    @Override
    public Metrics toHour() {
        SumPerMinFunction metrics = (SumPerMinFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.setTotal(this.getTotal());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        SumPerMinFunction metrics = (SumPerMinFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.setTotal(this.getTotal());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.getEntityId().hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTotal(remoteData.getDataLongs(0));
        this.setTimeBucket(remoteData.getDataLongs(1));
        this.setEntityId(remoteData.getDataStrings(0));
        this.setServiceId(remoteData.getDataStrings(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTotal());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.getEntityId());
        remoteBuilder.addDataStrings(this.getServiceId());
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public void accept(MeterEntity entity, Long value) {
        this.setEntityId(entity.id());
        this.setServiceId(entity.serviceId());
        this.setTotal(this.getTotal() + value);
    }

    @Override
    public Class<? extends StorageBuilder> builder() {
        return SumPerMinStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SumPerMinFunction)) {
            return false;
        }
        SumPerMinFunction function = (SumPerMinFunction)o;
        return Objects.equals(this.getEntityId(), function.getEntityId()) && Objects.equals(this.getTimeBucket(), function.getTimeBucket());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getEntityId(), this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "SumPerMinFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", value=" + this.getValue() + ", total=" + this.getTotal() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @Generated
    public long getValue() {
        return this.value;
    }

    @Generated
    public void setValue(long value) {
        this.value = value;
    }

    @Generated
    public long getTotal() {
        return this.total;
    }

    @Generated
    public void setTotal(long total) {
        this.total = total;
    }

    public static class SumPerMinStorageBuilder
    implements StorageBuilder<SumPerMinFunction> {
        @Override
        public SumPerMinFunction storage2Entity(Convert2Entity converter) {
            SumPerMinFunction metrics = new SumPerMinFunction(){

                @Override
                public AcceptableValue<Long> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setValue(((Number)converter.get(SumPerMinFunction.VALUE)).longValue());
            metrics.setTotal(((Number)converter.get(SumPerMinFunction.TOTAL)).longValue());
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(SumPerMinFunction storageData, Convert2Storage converter) {
            converter.accept(SumPerMinFunction.VALUE, storageData.getValue());
            converter.accept(SumPerMinFunction.TOTAL, storageData.getTotal());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

