/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.meter.function.avg;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.meter.Meter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.function.AcceptableValue;
import org.apache.skywalking.oap.server.core.analysis.meter.function.MeterFunction;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@MeterFunction(functionName="avgLabeled")
public abstract class AvgLabeledFunction
extends Meter
implements AcceptableValue<DataTable>,
LabeledValueHolder {
    protected static final String SUMMATION = "datatable_summation";
    protected static final String COUNT = "datatable_count";
    protected static final String VALUE = "datatable_value";
    @Column(name="entity_id", length=512)
    @BanyanDB.SeriesID(index=0)
    private String entityId;
    @Column(name="service_id")
    private String serviceId;
    @Column(name="datatable_summation", storageOnly=true)
    @ElasticSearch.Column(legacyName="summation")
    @BanyanDB.MeasureField
    protected DataTable summation = new DataTable(30);
    @Column(name="datatable_count", storageOnly=true)
    @ElasticSearch.Column(legacyName="count")
    @BanyanDB.MeasureField
    protected DataTable count = new DataTable(30);
    @Column(name="datatable_value", dataType=Column.ValueDataType.LABELED_VALUE, storageOnly=true)
    @ElasticSearch.Column(legacyName="value")
    @BanyanDB.MeasureField
    private DataTable value = new DataTable(30);

    @Override
    public final boolean combine(Metrics metrics) {
        AvgLabeledFunction longAvgMetrics = (AvgLabeledFunction)metrics;
        this.summation.append(longAvgMetrics.summation);
        this.count.append(longAvgMetrics.count);
        return true;
    }

    @Override
    public final void calculate() {
        Set<String> keys = this.count.keys();
        for (String key : keys) {
            Long c;
            Long s = this.summation.get(key);
            if (Objects.isNull(s) || Objects.isNull(c = this.count.get(key))) continue;
            long result = s / c;
            if (result == 0L && s > 0L) {
                result = 1L;
            }
            this.value.put(key, result);
        }
    }

    @Override
    public Metrics toHour() {
        AvgLabeledFunction metrics = (AvgLabeledFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInHour());
        metrics.setServiceId(this.getServiceId());
        metrics.getSummation().copyFrom(this.getSummation());
        metrics.getCount().copyFrom(this.getCount());
        return metrics;
    }

    @Override
    public Metrics toDay() {
        AvgLabeledFunction metrics = (AvgLabeledFunction)this.createNew();
        metrics.setEntityId(this.getEntityId());
        metrics.setTimeBucket(this.toTimeBucketInDay());
        metrics.setServiceId(this.getServiceId());
        metrics.getSummation().copyFrom(this.getSummation());
        metrics.getCount().copyFrom(this.getCount());
        return metrics;
    }

    @Override
    public int remoteHashCode() {
        return this.entityId.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setCount(new DataTable(remoteData.getDataObjectStrings(0)));
        this.setSummation(new DataTable(remoteData.getDataObjectStrings(1)));
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.entityId = remoteData.getDataStrings(0);
        this.serviceId = remoteData.getDataStrings(1);
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataObjectStrings(this.count.toStorageData());
        remoteBuilder.addDataObjectStrings(this.summation.toStorageData());
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.entityId);
        remoteBuilder.addDataStrings(this.serviceId);
        return remoteBuilder;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().append("time_bucket", this.getTimeBucket()).append("entity_id", this.getEntityId());
    }

    @Override
    public void accept(MeterEntity entity, DataTable value) {
        this.entityId = entity.id();
        this.serviceId = entity.serviceId();
        this.summation.append(value);
        DataTable c = new DataTable();
        value.keys().forEach(key -> c.put((String)key, 1L));
        this.count.append(c);
    }

    @Override
    public Class<? extends AvgLabeledStorageBuilder> builder() {
        return AvgLabeledStorageBuilder.class;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AvgLabeledFunction)) {
            return false;
        }
        AvgLabeledFunction function = (AvgLabeledFunction)o;
        return Objects.equals(this.entityId, function.entityId) && this.getTimeBucket() == function.getTimeBucket();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityId, this.getTimeBucket());
    }

    @Generated
    public String toString() {
        return "AvgLabeledFunction(entityId=" + this.getEntityId() + ", serviceId=" + this.getServiceId() + ", summation=" + this.getSummation() + ", count=" + this.getCount() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public DataTable getSummation() {
        return this.summation;
    }

    @Generated
    public void setSummation(DataTable summation) {
        this.summation = summation;
    }

    @Generated
    public DataTable getCount() {
        return this.count;
    }

    @Generated
    public void setCount(DataTable count) {
        this.count = count;
    }

    @Override
    @Generated
    public DataTable getValue() {
        return this.value;
    }

    @Generated
    public void setValue(DataTable value) {
        this.value = value;
    }

    public static class AvgLabeledStorageBuilder
    implements StorageBuilder<AvgLabeledFunction> {
        @Override
        public AvgLabeledFunction storage2Entity(Convert2Entity converter) {
            AvgLabeledFunction metrics = new AvgLabeledFunction(){

                @Override
                public AcceptableValue<DataTable> createNew() {
                    throw new UnexpectedException("createNew should not be called");
                }
            };
            metrics.setSummation(new DataTable((String)converter.get(AvgLabeledFunction.SUMMATION)));
            metrics.setValue(new DataTable((String)converter.get(AvgLabeledFunction.VALUE)));
            metrics.setCount(new DataTable((String)converter.get(AvgLabeledFunction.COUNT)));
            metrics.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            metrics.setServiceId((String)converter.get("service_id"));
            metrics.setEntityId((String)converter.get("entity_id"));
            return metrics;
        }

        @Override
        public void entity2Storage(AvgLabeledFunction storageData, Convert2Storage converter) {
            converter.accept(AvgLabeledFunction.SUMMATION, storageData.getSummation());
            converter.accept(AvgLabeledFunction.VALUE, storageData.getValue());
            converter.accept(AvgLabeledFunction.COUNT, storageData.getCount());
            converter.accept("time_bucket", storageData.getTimeBucket());
            converter.accept("service_id", storageData.getServiceId());
            converter.accept("entity_id", storageData.getEntityId());
        }
    }
}

