/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.process;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;
import org.apache.skywalking.oap.server.library.util.StringUtil;

@Stream(name="process_traffic", scopeId=45, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=true)
@BanyanDB.StoreIDAsTag
public class ProcessTraffic
extends Metrics {
    public static final String INDEX_NAME = "process_traffic";
    public static final String SERVICE_ID = "service_id";
    public static final String INSTANCE_ID = "instance_id";
    public static final String NAME = "name";
    public static final String AGENT_ID = "agent_id";
    public static final String PROPERTIES = "properties";
    public static final String LAST_PING_TIME_BUCKET = "last_ping";
    public static final String DETECT_TYPE = "detect_type";
    public static final String LABELS_JSON = "labels_json";
    public static final String PROFILING_SUPPORT_STATUS = "profiling_support_status";
    private static final Gson GSON = new Gson();
    @Column(name="service_id")
    private String serviceId;
    @Column(name="instance_id", length=600)
    @BanyanDB.SeriesID(index=0)
    private String instanceId;
    private String processId;
    @Column(name="name", length=500)
    @BanyanDB.SeriesID(index=1)
    private String name;
    @Column(name="last_ping")
    private long lastPingTimestamp;
    @Column(name="detect_type")
    private int detectType = ProcessDetectType.UNDEFINED.value();
    @Column(name="agent_id", length=500)
    private String agentId;
    @Column(name="properties", storageOnly=true, length=50000)
    private JsonObject properties;
    @Column(name="labels_json", storageOnly=true, length=500)
    private String labelsJson;
    @Column(name="profiling_support_status")
    private int profilingSupportStatus;

    @Override
    public boolean combine(Metrics metrics) {
        ProcessTraffic processTraffic = (ProcessTraffic)metrics;
        this.lastPingTimestamp = processTraffic.getLastPingTimestamp();
        if (StringUtil.isNotBlank((String)processTraffic.getAgentId())) {
            this.agentId = processTraffic.getAgentId();
        }
        if (this.properties == null) {
            this.properties = processTraffic.getProperties();
        } else if (processTraffic.getProperties() != null) {
            for (Map.Entry e : processTraffic.getProperties().entrySet()) {
                this.properties.add((String)e.getKey(), (JsonElement)e.getValue());
            }
        }
        if (processTraffic.getDetectType() > 0) {
            this.detectType = processTraffic.getDetectType();
        }
        if (StringUtil.isNotEmpty((String)processTraffic.getLabelsJson())) {
            this.labelsJson = processTraffic.getLabelsJson();
        }
        return true;
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setServiceId(remoteData.getDataStrings(0));
        this.setInstanceId(remoteData.getDataStrings(1));
        this.setName(remoteData.getDataStrings(2));
        this.setAgentId(remoteData.getDataStrings(3));
        String propString = remoteData.getDataStrings(4);
        if (StringUtil.isNotEmpty((String)propString)) {
            this.setProperties((JsonObject)GSON.fromJson(propString, JsonObject.class));
        }
        this.setLabelsJson(remoteData.getDataStrings(5));
        this.setLastPingTimestamp(remoteData.getDataLongs(0));
        this.setDetectType(remoteData.getDataIntegers(0));
        this.setProfilingSupportStatus(remoteData.getDataIntegers(1));
        this.setTimeBucket(remoteData.getDataLongs(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.serviceId);
        builder.addDataStrings(this.instanceId);
        builder.addDataStrings(this.name);
        builder.addDataStrings(this.agentId);
        if (this.properties == null) {
            builder.addDataStrings("");
        } else {
            builder.addDataStrings(GSON.toJson((JsonElement)this.properties));
        }
        builder.addDataStrings(this.labelsJson);
        builder.addDataLongs(this.lastPingTimestamp);
        builder.addDataIntegers(this.detectType);
        builder.addDataIntegers(this.profilingSupportStatus);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    protected StorageID id0() {
        if (this.processId == null) {
            this.processId = IDManager.ProcessID.buildId(this.instanceId, this.name);
        }
        return new StorageID().appendMutant(new String[]{INSTANCE_ID, NAME}, this.processId);
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessTraffic)) {
            return false;
        }
        ProcessTraffic other = (ProcessTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Generated
    public String getServiceId() {
        return this.serviceId;
    }

    @Generated
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setLastPingTimestamp(long lastPingTimestamp) {
        this.lastPingTimestamp = lastPingTimestamp;
    }

    @Generated
    public long getLastPingTimestamp() {
        return this.lastPingTimestamp;
    }

    @Generated
    public void setDetectType(int detectType) {
        this.detectType = detectType;
    }

    @Generated
    public int getDetectType() {
        return this.detectType;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public void setProperties(JsonObject properties) {
        this.properties = properties;
    }

    @Generated
    public JsonObject getProperties() {
        return this.properties;
    }

    @Generated
    public void setLabelsJson(String labelsJson) {
        this.labelsJson = labelsJson;
    }

    @Generated
    public String getLabelsJson() {
        return this.labelsJson;
    }

    @Generated
    public void setProfilingSupportStatus(int profilingSupportStatus) {
        this.profilingSupportStatus = profilingSupportStatus;
    }

    @Generated
    public int getProfilingSupportStatus() {
        return this.profilingSupportStatus;
    }

    public static class Builder
    implements StorageBuilder<ProcessTraffic> {
        @Override
        public ProcessTraffic storage2Entity(Convert2Entity converter) {
            ProcessTraffic processTraffic = new ProcessTraffic();
            processTraffic.setServiceId((String)converter.get(ProcessTraffic.SERVICE_ID));
            processTraffic.setInstanceId((String)converter.get(ProcessTraffic.INSTANCE_ID));
            processTraffic.setName((String)converter.get(ProcessTraffic.NAME));
            processTraffic.setAgentId((String)converter.get(ProcessTraffic.AGENT_ID));
            String propString = (String)converter.get(ProcessTraffic.PROPERTIES);
            if (StringUtil.isNotEmpty((String)propString)) {
                processTraffic.setProperties((JsonObject)GSON.fromJson(propString, JsonObject.class));
            }
            processTraffic.setLabelsJson((String)converter.get(ProcessTraffic.LABELS_JSON));
            processTraffic.setLastPingTimestamp(((Number)converter.get(ProcessTraffic.LAST_PING_TIME_BUCKET)).longValue());
            processTraffic.setDetectType(((Number)converter.get(ProcessTraffic.DETECT_TYPE)).intValue());
            processTraffic.setProfilingSupportStatus(((Number)converter.get(ProcessTraffic.PROFILING_SUPPORT_STATUS)).intValue());
            processTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return processTraffic;
        }

        @Override
        public void entity2Storage(ProcessTraffic storageData, Convert2Storage converter) {
            converter.accept(ProcessTraffic.SERVICE_ID, storageData.getServiceId());
            converter.accept(ProcessTraffic.INSTANCE_ID, storageData.getInstanceId());
            converter.accept(ProcessTraffic.NAME, storageData.getName());
            converter.accept(ProcessTraffic.AGENT_ID, storageData.getAgentId());
            if (storageData.getProperties() != null) {
                converter.accept(ProcessTraffic.PROPERTIES, GSON.toJson((JsonElement)storageData.getProperties()));
            } else {
                converter.accept(ProcessTraffic.PROPERTIES, "");
            }
            converter.accept(ProcessTraffic.LABELS_JSON, storageData.getLabelsJson());
            converter.accept(ProcessTraffic.LAST_PING_TIME_BUCKET, storageData.getLastPingTimestamp());
            converter.accept(ProcessTraffic.DETECT_TYPE, storageData.getDetectType());
            converter.accept(ProcessTraffic.PROFILING_SUPPORT_STATUS, storageData.getProfilingSupportStatus());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

