/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum Layer {
    UNDEFINED(0, false),
    MESH(1, true),
    GENERAL(2, true),
    OS_LINUX(3, true),
    K8S(4, true),
    FAAS(5, true),
    MESH_CP(6, true),
    MESH_DP(7, true),
    DATABASE(8, true),
    CACHE(9, true),
    BROWSER(10, true),
    SO11Y_OAP(11, true),
    SO11Y_SATELLITE(12, true),
    MQ(13, true),
    VIRTUAL_DATABASE(14, false),
    VIRTUAL_MQ(15, false),
    VIRTUAL_GATEWAY(16, false),
    K8S_SERVICE(17, true),
    MYSQL(18, true),
    VIRTUAL_CACHE(19, false),
    POSTGRESQL(20, true),
    APISIX(21, true),
    AWS_EKS(22, true),
    OS_WINDOWS(23, true),
    AWS_S3(24, true),
    AWS_DYNAMODB(25, true),
    AWS_GATEWAY(26, true),
    REDIS(27, true),
    ELASTICSEARCH(28, true),
    RABBITMQ(29, true);

    private final int value;
    private final boolean isNormal;
    private static final Map<Integer, Layer> DICTIONARY;
    private static final Map<String, Layer> DICTIONARY_NAME;

    private Layer(int value, boolean isNormal) {
        this.value = value;
        this.isNormal = isNormal;
    }

    public int value() {
        return this.value;
    }

    public static Layer valueOf(int value) {
        Layer layer = DICTIONARY.get(value);
        if (layer == null) {
            throw new UnexpectedException("Unknown Layer value");
        }
        return layer;
    }

    public static Layer nameOf(String name) {
        Layer layer = DICTIONARY_NAME.get(name);
        if (layer == null) {
            return UNDEFINED;
        }
        return layer;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    static {
        DICTIONARY = new HashMap<Integer, Layer>();
        DICTIONARY_NAME = new HashMap<String, Layer>();
        Arrays.stream(Layer.values()).forEach(l -> {
            DICTIONARY.put(l.value, (Layer)((Object)l));
            DICTIONARY_NAME.put(l.name(), (Layer)((Object)l));
        });
    }
}

