/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.SearchableTracesTagsWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;

public class CoreModuleConfig
extends ModuleConfig {
    private String role = "Mixed";
    private String namespace;
    private String restHost;
    private int restPort;
    private String restContextPath;
    private int restMaxThreads = 200;
    private long restIdleTimeOut = 30000L;
    private int restAcceptQueueSize = 0;
    private String gRPCHost;
    private int gRPCPort;
    private boolean gRPCSslEnabled = false;
    private String gRPCSslKeyPath;
    private String gRPCSslCertChainPath;
    private String gRPCSslTrustedCAPath;
    private int maxConcurrentCallsPerConnection;
    private int maxMessageSize;
    private int topNReportPeriod;
    private long l1FlushPeriod = 500L;
    private long storageSessionTimeout = 70000L;
    private final List<String> downsampling;
    private int persistentPeriod = 25;
    private boolean enableDataKeeperExecutor = true;
    private int dataKeeperExecutePeriod = 5;
    private int metricsDataTTL = 3;
    private int recordDataTTL = 7;
    private int gRPCThreadPoolSize;
    private int gRPCThreadPoolQueueSize;
    private int remoteTimeout = 20;
    private long maxSizeOfNetworkAddressAlias = 1000000L;
    private long maxSizeOfProfileTask = 10000L;
    private int maxPageSizeOfQueryProfileSnapshot = 500;
    private int maxSizeOfAnalyzeProfileSnapshot = 12000;
    private int maxDurationOfQueryEBPFProfilingData = 30;
    private int maxThreadCountOfQueryEBPFProfilingData = Runtime.getRuntime().availableProcessors();
    private boolean activeExtraModelColumns = false;
    private int serviceNameMaxLength = 70;
    private int instanceNameMaxLength = 70;
    private int endpointNameMaxLength = 150;
    private String searchableTracesTags = DEFAULT_SEARCHABLE_TAG_KEYS;
    private SearchableTracesTagsWatcher searchableTracesTagsWatcher;
    private String searchableLogsTags = "";
    private String searchableAlarmTags = "";
    private int autocompleteTagKeysQueryMaxSize = 100;
    private int autocompleteTagValuesQueryMaxSize = 100;
    private int prepareThreads = 2;
    private boolean enableEndpointNameGroupingByOpenapi = true;
    private int httpMaxRequestHeaderSize = 8192;
    private int maxHttpUrisNumberPerService = 3000;
    private static final String DEFAULT_SEARCHABLE_TAG_KEYS = String.join((CharSequence)",", "http.method", "status_code", "db.type", "db.instance", "mq.queue", "mq.topic", "mq.broker");

    public CoreModuleConfig() {
        this.downsampling = new ArrayList<String>();
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getRestHost() {
        return this.restHost;
    }

    @Generated
    public int getRestPort() {
        return this.restPort;
    }

    @Generated
    public String getRestContextPath() {
        return this.restContextPath;
    }

    @Generated
    public int getRestMaxThreads() {
        return this.restMaxThreads;
    }

    @Generated
    public long getRestIdleTimeOut() {
        return this.restIdleTimeOut;
    }

    @Generated
    public int getRestAcceptQueueSize() {
        return this.restAcceptQueueSize;
    }

    @Generated
    public String getGRPCHost() {
        return this.gRPCHost;
    }

    @Generated
    public int getGRPCPort() {
        return this.gRPCPort;
    }

    @Generated
    public boolean isGRPCSslEnabled() {
        return this.gRPCSslEnabled;
    }

    @Generated
    public String getGRPCSslKeyPath() {
        return this.gRPCSslKeyPath;
    }

    @Generated
    public String getGRPCSslCertChainPath() {
        return this.gRPCSslCertChainPath;
    }

    @Generated
    public String getGRPCSslTrustedCAPath() {
        return this.gRPCSslTrustedCAPath;
    }

    @Generated
    public int getMaxConcurrentCallsPerConnection() {
        return this.maxConcurrentCallsPerConnection;
    }

    @Generated
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    @Generated
    public int getTopNReportPeriod() {
        return this.topNReportPeriod;
    }

    @Generated
    public long getL1FlushPeriod() {
        return this.l1FlushPeriod;
    }

    @Generated
    public long getStorageSessionTimeout() {
        return this.storageSessionTimeout;
    }

    @Generated
    public List<String> getDownsampling() {
        return this.downsampling;
    }

    @Generated
    public int getPersistentPeriod() {
        return this.persistentPeriod;
    }

    @Generated
    public boolean isEnableDataKeeperExecutor() {
        return this.enableDataKeeperExecutor;
    }

    @Generated
    public int getDataKeeperExecutePeriod() {
        return this.dataKeeperExecutePeriod;
    }

    @Generated
    public int getMetricsDataTTL() {
        return this.metricsDataTTL;
    }

    @Generated
    public int getRecordDataTTL() {
        return this.recordDataTTL;
    }

    @Generated
    public int getGRPCThreadPoolSize() {
        return this.gRPCThreadPoolSize;
    }

    @Generated
    public int getGRPCThreadPoolQueueSize() {
        return this.gRPCThreadPoolQueueSize;
    }

    @Generated
    public int getRemoteTimeout() {
        return this.remoteTimeout;
    }

    @Generated
    public long getMaxSizeOfNetworkAddressAlias() {
        return this.maxSizeOfNetworkAddressAlias;
    }

    @Generated
    public long getMaxSizeOfProfileTask() {
        return this.maxSizeOfProfileTask;
    }

    @Generated
    public int getMaxPageSizeOfQueryProfileSnapshot() {
        return this.maxPageSizeOfQueryProfileSnapshot;
    }

    @Generated
    public int getMaxSizeOfAnalyzeProfileSnapshot() {
        return this.maxSizeOfAnalyzeProfileSnapshot;
    }

    @Generated
    public int getMaxDurationOfQueryEBPFProfilingData() {
        return this.maxDurationOfQueryEBPFProfilingData;
    }

    @Generated
    public int getMaxThreadCountOfQueryEBPFProfilingData() {
        return this.maxThreadCountOfQueryEBPFProfilingData;
    }

    @Generated
    public boolean isActiveExtraModelColumns() {
        return this.activeExtraModelColumns;
    }

    @Generated
    public int getServiceNameMaxLength() {
        return this.serviceNameMaxLength;
    }

    @Generated
    public int getInstanceNameMaxLength() {
        return this.instanceNameMaxLength;
    }

    @Generated
    public int getEndpointNameMaxLength() {
        return this.endpointNameMaxLength;
    }

    @Generated
    public int getHttpMaxRequestHeaderSize() {
        return this.httpMaxRequestHeaderSize;
    }

    @Generated
    public int getMaxHttpUrisNumberPerService() {
        return this.maxHttpUrisNumberPerService;
    }

    @Generated
    public void setPersistentPeriod(int persistentPeriod) {
        this.persistentPeriod = persistentPeriod;
    }

    @Generated
    public void setSearchableTracesTags(String searchableTracesTags) {
        this.searchableTracesTags = searchableTracesTags;
    }

    @Generated
    public String getSearchableTracesTags() {
        return this.searchableTracesTags;
    }

    @Generated
    public void setSearchableTracesTagsWatcher(SearchableTracesTagsWatcher searchableTracesTagsWatcher) {
        this.searchableTracesTagsWatcher = searchableTracesTagsWatcher;
    }

    @Generated
    public SearchableTracesTagsWatcher getSearchableTracesTagsWatcher() {
        return this.searchableTracesTagsWatcher;
    }

    @Generated
    public void setSearchableLogsTags(String searchableLogsTags) {
        this.searchableLogsTags = searchableLogsTags;
    }

    @Generated
    public String getSearchableLogsTags() {
        return this.searchableLogsTags;
    }

    @Generated
    public void setSearchableAlarmTags(String searchableAlarmTags) {
        this.searchableAlarmTags = searchableAlarmTags;
    }

    @Generated
    public String getSearchableAlarmTags() {
        return this.searchableAlarmTags;
    }

    @Generated
    public void setAutocompleteTagKeysQueryMaxSize(int autocompleteTagKeysQueryMaxSize) {
        this.autocompleteTagKeysQueryMaxSize = autocompleteTagKeysQueryMaxSize;
    }

    @Generated
    public int getAutocompleteTagKeysQueryMaxSize() {
        return this.autocompleteTagKeysQueryMaxSize;
    }

    @Generated
    public void setAutocompleteTagValuesQueryMaxSize(int autocompleteTagValuesQueryMaxSize) {
        this.autocompleteTagValuesQueryMaxSize = autocompleteTagValuesQueryMaxSize;
    }

    @Generated
    public int getAutocompleteTagValuesQueryMaxSize() {
        return this.autocompleteTagValuesQueryMaxSize;
    }

    @Generated
    public void setPrepareThreads(int prepareThreads) {
        this.prepareThreads = prepareThreads;
    }

    @Generated
    public int getPrepareThreads() {
        return this.prepareThreads;
    }

    @Generated
    public boolean isEnableEndpointNameGroupingByOpenapi() {
        return this.enableEndpointNameGroupingByOpenapi;
    }

    @Generated
    public void setEnableEndpointNameGroupingByOpenapi(boolean enableEndpointNameGroupingByOpenapi) {
        this.enableEndpointNameGroupingByOpenapi = enableEndpointNameGroupingByOpenapi;
    }

    public static enum Role {
        Mixed,
        Receiver,
        Aggregator;


        public static Role fromName(String name) {
            for (Role role : Role.values()) {
                if (!role.name().equalsIgnoreCase(name)) continue;
                return role;
            }
            return Mixed;
        }
    }
}

