/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.k8s;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Service;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.skywalking.library.kubernetes.KubernetesPods;
import org.apache.skywalking.library.kubernetes.KubernetesServices;
import org.apache.skywalking.library.kubernetes.ObjectID;

public class K8sInfoRegistry {
    private static final K8sInfoRegistry INSTANCE = new K8sInfoRegistry();
    private final LoadingCache<ObjectID, ObjectID> podServiceMap;
    private final LoadingCache<String, ObjectID> ipPodMap = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L)).build(CacheLoader.from(ip -> KubernetesPods.INSTANCE.findByIP(ip).map(it -> ObjectID.builder().name(it.getMetadata().getName()).namespace(it.getMetadata().getNamespace()).build()).orElse(ObjectID.EMPTY)));
    private final LoadingCache<String, ObjectID> ipServiceMap = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L)).build(CacheLoader.from(ip -> KubernetesServices.INSTANCE.list().stream().filter(it -> it.getSpec() != null).filter(it -> it.getStatus() != null).filter(it -> it.getMetadata() != null).filter(it -> it.getSpec().getClusterIPs() != null && it.getSpec().getClusterIPs().stream().anyMatch(clusterIP -> Objects.equals(clusterIP, ip)) || it.getStatus().getLoadBalancer() != null && it.getStatus().getLoadBalancer().getIngress() != null && it.getStatus().getLoadBalancer().getIngress().stream().anyMatch(ingress -> Objects.equals(ingress.getIp(), ip))).map(it -> ObjectID.builder().name(it.getMetadata().getName()).namespace(it.getMetadata().getNamespace()).build()).findFirst().orElse(ObjectID.EMPTY)));

    private K8sInfoRegistry() {
        this.podServiceMap = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L)).build(CacheLoader.from(podObjectID -> {
            Optional pod = KubernetesPods.INSTANCE.findByObjectID(ObjectID.builder().name(podObjectID.name()).namespace(podObjectID.namespace()).build());
            if (!pod.isPresent() || ((Pod)pod.get()).getMetadata() == null || ((Pod)pod.get()).getMetadata().getLabels() == null) {
                return ObjectID.EMPTY;
            }
            Optional<Service> service = KubernetesServices.INSTANCE.list().stream().filter(it -> it.getMetadata() != null).filter(it -> Objects.equals(it.getMetadata().getNamespace(), ((Pod)pod.get()).getMetadata().getNamespace())).filter(it -> it.getSpec() != null).filter(it -> Objects.requireNonNull(it.getSpec()).getSelector() != null).filter(it -> {
                Map labels = ((Pod)pod.get()).getMetadata().getLabels();
                Map selector = it.getSpec().getSelector();
                return this.hasIntersection(selector.entrySet(), labels.entrySet());
            }).findFirst();
            if (!service.isPresent()) {
                return ObjectID.EMPTY;
            }
            return ObjectID.builder().name(service.get().getMetadata().getName()).namespace(service.get().getMetadata().getNamespace()).build();
        }));
    }

    public static K8sInfoRegistry getInstance() {
        return INSTANCE;
    }

    public String findServiceName(String namespace, String podName) {
        return ((ObjectID)this.podServiceMap.get((Object)ObjectID.builder().name(podName).namespace(namespace).build())).toString();
    }

    public String findPodByIP(String ip) {
        return ((ObjectID)this.ipPodMap.get((Object)ip)).toString();
    }

    public String findServiceByIP(String ip) {
        return ((ObjectID)this.ipServiceMap.get((Object)ip)).toString();
    }

    private boolean hasIntersection(Collection<?> o, Collection<?> c) {
        Objects.requireNonNull(o);
        Objects.requireNonNull(c);
        for (Object value : o) {
            if (c.contains(value)) continue;
            return false;
        }
        return true;
    }
}

