/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.meter.analyzer.dsl.registry;

import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.meter.analyzer.k8s.K8sInfoRegistry;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessDetectType;
import org.apache.skywalking.oap.server.core.analysis.manual.process.ProcessTraffic;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;

public class ProcessRegistry {
    public static final String LOCAL_VIRTUAL_PROCESS = "UNKNOWN_LOCAL";
    public static final String REMOTE_VIRTUAL_PROCESS = "UNKNOWN_REMOTE";

    public static String generateVirtualLocalProcess(String service, String instance) {
        return ProcessRegistry.generateVirtualProcess(service, instance, LOCAL_VIRTUAL_PROCESS);
    }

    public static String generateVirtualRemoteProcess(String service, String instance, String remoteAddress) {
        String ip = StringUtils.substringBeforeLast((String)remoteAddress, (String)":");
        String name = K8sInfoRegistry.getInstance().findPodByIP(ip);
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = K8sInfoRegistry.getInstance().findServiceByIP(ip);
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = REMOTE_VIRTUAL_PROCESS;
        }
        return ProcessRegistry.generateVirtualProcess(service, instance, name);
    }

    public static String generateVirtualProcess(String service, String instance, String processName) {
        ProcessTraffic traffic = new ProcessTraffic();
        String serviceId = IDManager.ServiceID.buildId((String)service, (boolean)true);
        traffic.setServiceId(serviceId);
        traffic.setInstanceId(IDManager.ServiceInstanceID.buildId((String)serviceId, (String)instance));
        traffic.setName(processName);
        traffic.setAgentId("");
        traffic.setLabelsJson("");
        traffic.setDetectType(ProcessDetectType.VIRTUAL.value());
        long timeBucket = TimeBucket.getTimeBucket((long)System.currentTimeMillis(), (DownSampling)DownSampling.Minute);
        traffic.setTimeBucket(timeBucket);
        traffic.setLastPingTimestamp(timeBucket);
        MetricsStreamProcessor.getInstance().in((Metrics)traffic);
        return traffic.id().build();
    }
}

