/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.recevier.log.provider.handler.grpc;

import io.grpc.stub.StreamObserver;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogReportServiceGrpc;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalyzerService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReportServiceGrpcHandler
extends LogReportServiceGrpc.LogReportServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogReportServiceGrpcHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private final ILogAnalyzerService logAnalyzerService;

    public LogReportServiceGrpcHandler(ModuleManager moduleManager) {
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.logAnalyzerService = (ILogAnalyzerService)moduleManager.find("log-analyzer").provider().getService(ILogAnalyzerService.class);
        this.histogram = metricsCreator.createHistogramMetric("log_in_latency", "The process latency of log", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("log_analysis_error_count", "The error number of log analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"grpc"}));
    }

    public StreamObserver<LogData> collect(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<LogData>(){
            private String serviceName;

            private void setServiceName(LogData.Builder builder) {
                if (StringUtil.isEmpty((String)this.serviceName) && StringUtil.isNotEmpty((String)builder.getService())) {
                    this.serviceName = builder.getService();
                } else if (StringUtil.isNotEmpty((String)this.serviceName)) {
                    builder.setService(this.serviceName);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(LogData logData) {
                if (log.isDebugEnabled()) {
                    log.debug("received log in streaming");
                }
                HistogramMetrics.Timer timer = LogReportServiceGrpcHandler.this.histogram.createTimer();
                try {
                    LogData.Builder builder = logData.toBuilder();
                    this.setServiceName(builder);
                    LogReportServiceGrpcHandler.this.logAnalyzerService.doAnalysis(builder, null);
                }
                catch (Exception e) {
                    LogReportServiceGrpcHandler.this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    timer.finish();
                }
            }

            public void onError(Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

