/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.recevier.configuration.discovery;

import com.google.common.hash.Hashing;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.recevier.configuration.discovery.AgentConfigurations;
import org.apache.skywalking.oap.server.recevier.configuration.discovery.AgentConfigurationsReader;
import org.apache.skywalking.oap.server.recevier.configuration.discovery.AgentConfigurationsTable;

public class AgentConfigurationsWatcher
extends ConfigChangeWatcher {
    private volatile String settingsString = null;
    private volatile AgentConfigurationsTable agentConfigurationsTable = new AgentConfigurationsTable();
    private final AgentConfigurations emptyAgentConfigurations = new AgentConfigurations(null, new HashMap<String, String>(), Hashing.sha512().hashString((CharSequence)"EMPTY", StandardCharsets.UTF_8).toString());

    public AgentConfigurationsWatcher(ModuleProvider provider) {
        super("configuration-discovery", provider, "agentConfigurations");
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (value.getEventType().equals((Object)ConfigChangeWatcher.EventType.DELETE)) {
            this.settingsString = null;
            this.agentConfigurationsTable = new AgentConfigurationsTable();
        } else {
            this.settingsString = value.getNewValue();
            AgentConfigurationsReader agentConfigurationsReader = new AgentConfigurationsReader(new StringReader(value.getNewValue()));
            this.agentConfigurationsTable = agentConfigurationsReader.readAgentConfigurationsTable();
        }
    }

    public String value() {
        return this.settingsString;
    }

    public AgentConfigurations getAgentConfigurations(String service) {
        AgentConfigurations agentConfigurations = this.agentConfigurationsTable.getAgentConfigurationsCache().get(service);
        if (null == agentConfigurations) {
            return this.emptyAgentConfigurations;
        }
        return agentConfigurations;
    }
}

