/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.kafka;

import com.google.gson.Gson;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.server.pool.CustomThreadFactory;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.apache.skywalking.oap.server.receiver.zipkin.trace.SpanForward;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.SpanBytesDecoderDetector;
import zipkin2.codec.BytesDecoder;

public class KafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaHandler.class);
    private final ZipkinReceiverConfig config;
    private final SpanForward spanForward;
    private final Properties properties;
    private final ThreadPoolExecutor executor;
    private final boolean enableKafkaMessageAutoCommit;
    private final List<String> topics;
    private final CounterMetrics msgDroppedIncr;
    private final CounterMetrics errorCounter;
    private final HistogramMetrics histogram;

    public KafkaHandler(ZipkinReceiverConfig config, ModuleManager manager) {
        this.config = config;
        this.spanForward = new SpanForward(config, manager);
        this.properties = new Properties();
        this.properties.setProperty("group.id", config.getKafkaGroupId());
        this.properties.setProperty("bootstrap.servers", config.getKafkaBootstrapServers());
        this.properties.setProperty("key.deserializer", ByteArrayDeserializer.class.getName());
        this.properties.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        Gson gson = new Gson();
        Properties override = (Properties)gson.fromJson(config.getKafkaConsumerConfig(), Properties.class);
        this.properties.putAll((Map<?, ?>)override);
        int threadPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        if (config.getKafkaHandlerThreadPoolSize() > 0) {
            threadPoolSize = config.getKafkaHandlerThreadPoolSize();
        }
        int threadPoolQueueSize = 10000;
        if (config.getKafkaHandlerThreadPoolQueueSize() > 0) {
            threadPoolQueueSize = config.getKafkaHandlerThreadPoolQueueSize();
        }
        this.enableKafkaMessageAutoCommit = new ConsumerConfig(this.properties).getBoolean("enable.auto.commit");
        this.executor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadPoolQueueSize), (ThreadFactory)new CustomThreadFactory("Zipkin-Kafka-Consumer"), new ThreadPoolExecutor.CallerRunsPolicy());
        this.topics = Arrays.asList(config.getKafkaTopic().split(","));
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("trace_in_latency", "The process latency of trace data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"zipkin-kafka"}), new double[0]);
        this.msgDroppedIncr = metricsCreator.createCounter("trace_dropped_count", "The dropped number of traces", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"zipkin-kafka"}));
        this.errorCounter = metricsCreator.createCounter("trace_analysis_error_count", "The error number of trace analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"zipkin-kafka"}));
    }

    public void start() throws ModuleStartException {
        for (int i = 0; i < this.config.getKafkaConsumers(); ++i) {
            KafkaConsumer consumer = new KafkaConsumer(this.properties);
            consumer.subscribe(this.topics);
            consumer.seekToEnd((Collection)consumer.assignment());
            this.executor.submit(() -> this.runTask((KafkaConsumer<byte[], byte[]>)consumer));
        }
    }

    private void runTask(KafkaConsumer<byte[], byte[]> consumer) {
        if (log.isDebugEnabled()) {
            log.debug("Start Consume zipkin trace records from kafka.");
        }
        while (true) {
            try {
                while (true) {
                    ConsumerRecords consumerRecords = consumer.poll(Duration.ofMillis(1000L));
                    if (log.isDebugEnabled()) {
                        log.debug("Consume zipkin trace records from kafka, records count:[{}].", (Object)consumerRecords.count());
                    }
                    if (consumerRecords.isEmpty()) continue;
                    for (ConsumerRecord record : consumerRecords) {
                        byte[] bytes = (byte[])record.value();
                        if (bytes.length < 2) {
                            this.msgDroppedIncr.inc();
                            continue;
                        }
                        this.executor.submit(() -> this.handleRecord(bytes));
                    }
                    if (this.enableKafkaMessageAutoCommit) continue;
                    consumer.commitAsync();
                }
            }
            catch (Exception e) {
                log.error("Kafka handle message error.", (Throwable)e);
                this.errorCounter.inc();
                continue;
            }
            break;
        }
    }

    private void handleRecord(byte[] bytes) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            BytesDecoder decoder = SpanBytesDecoderDetector.decoderForListMessage((byte[])bytes);
            List spanList = decoder.decodeList(bytes);
            this.spanForward.send(spanList);
        }
    }
}

