/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.response.Document;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplate;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.core.storage.management.UITemplateManagementDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.library.util.BooleanUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.ElasticSearchConverter;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UITemplateManagementEsDAO
extends EsDAO
implements UITemplateManagementDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UITemplateManagementEsDAO.class);

    public UITemplateManagementEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public DashboardConfiguration getTemplate(String id) {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ui_template");
        SearchBuilder search = Search.builder().query((QueryBuilder)Query.ids((String[])new String[]{id})).size(Integer.valueOf(1));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        if (response.getHits().getHits().size() > 0) {
            UITemplate.Builder builder = new UITemplate.Builder();
            SearchHit data = (SearchHit)response.getHits().getHits().get(0);
            return new DashboardConfiguration().fromEntity(builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ui_template", data.getSource())));
        }
        return null;
    }

    public List<DashboardConfiguration> getAllTemplates(Boolean includingDisabled) {
        BoolQueryBuilder boolQuery = Query.bool();
        if (!includingDisabled.booleanValue()) {
            boolQuery.must((QueryBuilder)Query.term((String)"disabled", (Object)BooleanUtils.booleanToValue((Boolean)includingDisabled)));
        }
        SearchBuilder search = Search.builder().query((QueryBuilder)boolQuery).size(Integer.valueOf(10000));
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ui_template");
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        ArrayList<DashboardConfiguration> configs = new ArrayList<DashboardConfiguration>();
        UITemplate.Builder builder = new UITemplate.Builder();
        for (SearchHit searchHit : response.getHits()) {
            Map sourceAsMap = searchHit.getSource();
            UITemplate uiTemplate = builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ui_template", sourceAsMap));
            configs.add(new DashboardConfiguration().fromEntity(uiTemplate));
        }
        return configs;
    }

    public TemplateChangeStatus addTemplate(DashboardSetting setting) {
        try {
            UITemplate.Builder builder = new UITemplate.Builder();
            UITemplate uiTemplate = setting.toEntity();
            boolean exist = ((ElasticSearchClient)this.getClient()).existDoc("ui_template", uiTemplate.id().build());
            if (exist) {
                return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Template exists").build();
            }
            ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage("ui_template");
            builder.entity2Storage(uiTemplate, (Convert2Storage)toStorage);
            ((ElasticSearchClient)this.getClient()).forceInsert("ui_template", uiTemplate.id().build(), (Map)toStorage.obtain());
            return TemplateChangeStatus.builder().status(true).id(uiTemplate.getTemplateId()).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't add a new template").build();
        }
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) {
        try {
            UITemplate.Builder builder = new UITemplate.Builder();
            UITemplate uiTemplate = setting.toEntity();
            boolean exist = ((ElasticSearchClient)this.getClient()).existDoc("ui_template", uiTemplate.id().build());
            if (!exist) {
                return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't find the template").build();
            }
            ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage("ui_template");
            builder.entity2Storage(uiTemplate, (Convert2Storage)toStorage);
            ((ElasticSearchClient)this.getClient()).forceUpdate("ui_template", uiTemplate.id().build(), (Map)toStorage.obtain());
            return TemplateChangeStatus.builder().status(true).id(setting.getId()).build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("Can't find the template").build();
        }
    }

    public TemplateChangeStatus disableTemplate(String id) {
        Optional response = ((ElasticSearchClient)this.getClient()).get("ui_template", id);
        if (response.isPresent()) {
            UITemplate.Builder builder = new UITemplate.Builder();
            UITemplate uiTemplate = builder.storage2Entity((Convert2Entity)new ElasticSearchConverter.ToEntity("ui_template", ((Document)response.get()).getSource()));
            uiTemplate.setDisabled(1);
            ElasticSearchConverter.ToStorage toStorage = new ElasticSearchConverter.ToStorage("ui_template");
            builder.entity2Storage(uiTemplate, (Convert2Storage)toStorage);
            ((ElasticSearchClient)this.getClient()).forceUpdate("ui_template", uiTemplate.id().build(), (Map)toStorage.obtain());
            return TemplateChangeStatus.builder().status(true).id(id).build();
        }
        return TemplateChangeStatus.builder().status(false).id(id).message("Can't find the template").build();
    }
}

