/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.Aggregation;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.AggregationBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.aggregation.TermsAggregationBuilder;
import org.apache.skywalking.library.elasticsearch.response.Document;
import org.apache.skywalking.library.elasticsearch.response.Documents;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHits;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.sql.Function;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.NullableValue;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeRangeIndexNameGenerator;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.TimeSeriesUtils;

public class MetricsQueryEsDAO
extends EsDAO
implements IMetricsQueryDAO {
    public MetricsQueryEsDAO(ElasticSearchClient client) {
        super(client);
    }

    public NullableValue readMetricsValue(MetricsCondition condition, String valueColumnName, Duration duration) {
        Map idTerms;
        List buckets;
        Iterator iterator;
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        SearchBuilder sourceBuilder = this.buildQuery(condition, duration);
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        Function function = ValueColumnMetadata.INSTANCE.getValueFunction(condition.getName());
        if (function == Function.Latest) {
            return this.readMetricsValues(condition, realValueColumn, duration).getValues().latestValue(defaultValue);
        }
        TermsAggregationBuilder entityIdAggregation = Aggregation.terms((String)"entity_id").field("entity_id").executionHint(TermsAggregationBuilder.ExecutionHint.MAP).collectMode(TermsAggregationBuilder.CollectMode.BREADTH_FIRST).size(1);
        this.functionAggregation(function, entityIdAggregation, realValueColumn);
        sourceBuilder.aggregation((AggregationBuilder)entityIdAggregation);
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search((Supplier)new TimeRangeIndexNameGenerator(IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName()), duration.getStartTimeBucketInSec(), duration.getEndTimeBucketInSec()), sourceBuilder.build());
        if (Objects.nonNull(response.getAggregations()) && (iterator = (buckets = (List)(idTerms = (Map)response.getAggregations().get("entity_id")).get("buckets")).iterator()).hasNext()) {
            Map idBucket = (Map)iterator.next();
            Map agg = (Map)idBucket.get(realValueColumn);
            return new NullableValue(((Number)agg.get("value")).longValue(), false);
        }
        return new NullableValue((long)defaultValue, true);
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) {
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        String tableName = IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName());
        List pointOfTimes = duration.assembleDurationPoints();
        HashMap indexIdsGroup = new HashMap();
        List ids = pointOfTimes.stream().map(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            if (IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
                id = IndexController.INSTANCE.generateDocId(condition.getName(), id);
            }
            String indexName = TimeSeriesUtils.queryIndexName(tableName, pointOfTime.getPoint(), duration.getStep(), false, false);
            indexIdsGroup.computeIfAbsent(indexName, v -> new ArrayList()).add(id);
            return id;
        }).collect(Collectors.toList());
        MetricsValues metricsValues = new MetricsValues();
        Optional response = ((ElasticSearchClient)this.getClient()).ids(indexIdsGroup);
        if (response.isPresent()) {
            Map<String, Map<String, Object>> idMap = this.toMap((Documents)response.get());
            IntValues intValues = metricsValues.getValues();
            for (String id : ids) {
                KVInt kvInt = new KVInt();
                kvInt.setId(id);
                if (!idMap.containsKey(id)) continue;
                Map<String, Object> source = idMap.get(id);
                if (source.get(realValueColumn) != null) {
                    kvInt.setValue(((Number)source.get(realValueColumn)).longValue());
                } else {
                    kvInt.setValue((long)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
                    kvInt.setEmptyValue(true);
                }
                intValues.addKVInt(kvInt);
            }
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)metricsValues.getValues(), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<String> labels, Duration duration) {
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        List pointOfTimes = duration.assembleDurationPoints();
        String tableName = IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName());
        HashMap indexIdsGroup = new HashMap();
        boolean aggregationMode = !tableName.equals(condition.getName());
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            if (aggregationMode) {
                id = IndexController.INSTANCE.generateDocId(condition.getName(), id);
            }
            ids.add(id);
            String indexName = TimeSeriesUtils.queryIndexName(tableName, pointOfTime.getPoint(), duration.getStep(), false, false);
            indexIdsGroup.computeIfAbsent(indexName, v -> new ArrayList()).add(id);
        });
        Optional response = ((ElasticSearchClient)this.getClient()).ids(indexIdsGroup);
        HashMap<String, DataTable> idMap = new HashMap<String, DataTable>();
        if (response.isPresent()) {
            for (Document document : (Documents)response.get()) {
                if (document.getSource().get(realValueColumn) == null) continue;
                idMap.put(document.getId(), new DataTable((String)document.getSource().get(realValueColumn)));
            }
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((MetricsCondition)condition, labels, idMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) {
        String realValueColumn = IndexController.LogicIndicesRegister.getPhysicalColumnName(condition.getName(), valueColumnName);
        List pointOfTimes = duration.assembleDurationPoints();
        String tableName = IndexController.LogicIndicesRegister.getPhysicalTableName(condition.getName());
        HashMap indexIdsGroup = new HashMap();
        boolean aggregationMode = !tableName.equals(condition.getName());
        ArrayList ids = new ArrayList(pointOfTimes.size());
        pointOfTimes.forEach(pointOfTime -> {
            String id = pointOfTime.id(condition.getEntity().buildId());
            if (aggregationMode) {
                id = IndexController.INSTANCE.generateDocId(condition.getName(), id);
            }
            ids.add(id);
            String indexName = TimeSeriesUtils.queryIndexName(tableName, pointOfTime.getPoint(), duration.getStep(), false, false);
            indexIdsGroup.computeIfAbsent(indexName, v -> new ArrayList()).add(id);
        });
        HeatMap heatMap = new HeatMap();
        Optional response = ((ElasticSearchClient)this.getClient()).ids(indexIdsGroup);
        if (!response.isPresent()) {
            return heatMap;
        }
        Map<String, Map<String, Object>> idMap = this.toMap((Documents)response.get());
        int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
        for (String id : ids) {
            Map<String, Object> source = idMap.get(id);
            if (source == null) continue;
            String value = (String)source.get(realValueColumn);
            heatMap.buildColumn(id, value, defaultValue);
        }
        heatMap.fixMissingColumns(ids, defaultValue);
        return heatMap;
    }

    protected void functionAggregation(Function function, TermsAggregationBuilder parentAggBuilder, String valueCName) {
        switch (function) {
            case Avg: {
                parentAggBuilder.subAggregation((AggregationBuilder)Aggregation.avg((String)valueCName).field(valueCName));
                break;
            }
            case Sum: {
                parentAggBuilder.subAggregation((AggregationBuilder)Aggregation.sum((String)valueCName).field(valueCName));
                break;
            }
            default: {
                parentAggBuilder.subAggregation((AggregationBuilder)Aggregation.avg((String)valueCName).field(valueCName));
            }
        }
    }

    protected final SearchBuilder buildQuery(MetricsCondition condition, Duration duration) {
        SearchBuilder sourceBuilder = Search.builder();
        RangeQueryBuilder rangeQueryBuilder = Query.range((String)"time_bucket").gte((Object)duration.getStartTimeBucket()).lte((Object)duration.getEndTimeBucket());
        String entityId = condition.getEntity().buildId();
        if (entityId == null && IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            sourceBuilder.query((QueryBuilder)Query.bool().must((QueryBuilder)rangeQueryBuilder).must((QueryBuilder)Query.term((String)"metric_table", (Object)condition.getName())));
        } else if (entityId == null) {
            sourceBuilder.query((QueryBuilder)rangeQueryBuilder);
        } else if (IndexController.LogicIndicesRegister.isMergedTable(condition.getName())) {
            sourceBuilder.query((QueryBuilder)Query.bool().must((QueryBuilder)rangeQueryBuilder).must((QueryBuilder)Query.terms((String)"entity_id", (Object[])new Object[]{entityId})).must((QueryBuilder)Query.term((String)"metric_table", (Object)condition.getName())));
        } else {
            sourceBuilder.query((QueryBuilder)Query.bool().must((QueryBuilder)rangeQueryBuilder).must((QueryBuilder)Query.terms((String)"entity_id", (Object[])new Object[]{entityId})));
        }
        sourceBuilder.size(Integer.valueOf(0));
        return sourceBuilder;
    }

    private Map<String, Map<String, Object>> toMap(SearchHits hits) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (SearchHit hit : hits) {
            result.put(hit.getId(), hit.getSource());
        }
        return result;
    }

    private Map<String, Map<String, Object>> toMap(Documents documents) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (Document document : documents) {
            result.put(document.getId(), document.getSource());
        }
        return result;
    }
}

