# Working with Istio

This document provides instructions on transporting Istio's metrics to the SkyWalking OAP server.

## Prerequisites

Istio should be installed in a Kubernetes cluster. Simply follow the steps in [Getting Started in Istio](https://istio.io/docs/setup/getting-started/).

## Deploy SkyWalking backend

Follow the steps in [deploying backend in Kubernetes](../backend/backend-k8s.md) to install the OAP server in the Kubernetes cluster.
Refer to [OpenTelemetry receiver](../backend/opentelemetry-receiver.md) to ingest metrics.


## Deploy OpenTelemetry Collector
OpenTelemetry Collector is the location where Istio telemetry sends metrics, which are then processed and shipped to SkyWalking
backend.

To deploy this collector, follow the steps in [Getting Started in OpenTelemetry Collector](https://opentelemetry.io/docs/collector/getting-started/).
Several components are available in the collector, and they could be combined for different use cases.

After installing the collector, you may configure it to scrape metrics from Istio and send them to SkyWalking backend.

The job configuration to scrape metrics from Istio and send them to SkyWalking backend is as follows:

```yaml
receivers:
  prometheus:
    config:
     scrape_configs:
     - job_name: 'istiod-monitor'
       kubernetes_sd_configs:
        - role: endpoints
       relabel_configs:
        - source_labels: [ __meta_kubernetes_service_name, __meta_kubernetes_endpoint_port_name ]
          action: keep
          regex: istiod;http-monitoring
        - action: labelmap
          regex: __meta_kubernetes_service_label_(.+)
        - source_labels: [ ]
          target_label: cluster
          replacement: your-cluster # replace this with your cluster name

exporters:
  otlp:
    endpoint: oap.skywalking:11800 # replace this with the OAP gRPC service address
    tls:
      insecure: true

service:
  pipelines:
    metrics:
      receivers: [ prometheus ]
      exporters: [ otlp,logging ]
```

## Observing Istio

Open Istio Dashboard in SkyWaling UI by clicking `Dashboard` -> `Istio`. You can then view charts and diagrams
generated by Istio metrics. You may also view them through `swctl` and set up alarm rules based on them.


Note: If you would like to see metrics of Istio managed services, including topology, you may try our [ALS solution](../envoy/als_setting.md).
