/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.language.agent.v3.JVMMetricCollection;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.AbstractKafkaHandler;
import org.apache.skywalking.oap.server.analyzer.provider.jvm.JVMSourceDispatcher;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMMetricsHandler
extends AbstractKafkaHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JVMMetricsHandler.class);
    private final NamingControl namingLengthControl;
    private final JVMSourceDispatcher jvmSourceDispatcher;
    private final HistogramMetrics histogram;
    private final HistogramMetrics histogramBatch;
    private final CounterMetrics errorCounter;

    public JVMMetricsHandler(ModuleManager manager, KafkaFetcherConfig config) {
        super(manager, config);
        this.jvmSourceDispatcher = new JVMSourceDispatcher(manager);
        this.namingLengthControl = (NamingControl)manager.find("core").provider().getService(NamingControl.class);
        MetricsCreator metricsCreator = (MetricsCreator)manager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("meter_in_latency", "The process latency of meter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}), new double[0]);
        this.histogramBatch = metricsCreator.createHistogramMetric("meter_in_latency", "The process latency of meter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("meter_analysis_error_count", "The error number of meter analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
    }

    @Override
    public void handle(ConsumerRecord<String, Bytes> record) {
        try (HistogramMetrics.Timer ignored = this.histogramBatch.createTimer();){
            JVMMetricCollection metrics = JVMMetricCollection.parseFrom((byte[])((Bytes)record.value()).get());
            if (log.isDebugEnabled()) {
                log.debug("Fetched JVM metrics from service[{}] instance[{}] reported.", (Object)metrics.getService(), (Object)metrics.getServiceInstance());
            }
            JVMMetricCollection.Builder builder = metrics.toBuilder();
            builder.setService(this.namingLengthControl.formatServiceName(builder.getService()));
            builder.setServiceInstance(this.namingLengthControl.formatInstanceName(builder.getServiceInstance()));
            builder.getMetricsList().forEach(jvmMetric -> {
                try (HistogramMetrics.Timer ignored2 = this.histogram.createTimer();){
                    this.jvmSourceDispatcher.sendMetric(builder.getService(), builder.getServiceInstance(), jvmMetric);
                }
                catch (Exception e) {
                    this.errorCounter.inc();
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            log.error("handle record failed", (Throwable)e);
        }
    }

    @Override
    protected String getPlainTopic() {
        return this.config.getTopicNameOfMetrics();
    }
}

