/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider;

import lombok.Generated;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.KafkaFetcherHandlerRegister;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherModule;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.JVMMetricsHandler;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.JsonLogHandler;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.LogHandler;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.MeterServiceHandler;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.ProfileTaskHandler;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.ServiceManagementHandler;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.TraceSegmentHandler;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaFetcherProvider
extends ModuleProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaFetcherProvider.class);
    private KafkaFetcherHandlerRegister handlerRegister;
    private final KafkaFetcherConfig config = new KafkaFetcherConfig();

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return KafkaFetcherModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException {
        this.handlerRegister = new KafkaFetcherHandlerRegister(this.config);
    }

    public void start() throws ServiceNotProvidedException, ModuleStartException {
        this.handlerRegister.register(new JVMMetricsHandler(this.getManager(), this.config));
        this.handlerRegister.register(new ServiceManagementHandler(this.getManager(), this.config));
        this.handlerRegister.register(new TraceSegmentHandler(this.getManager(), this.config));
        this.handlerRegister.register(new ProfileTaskHandler(this.getManager(), this.config));
        this.handlerRegister.register(new MeterServiceHandler(this.getManager(), this.config));
        if (this.config.isEnableNativeProtoLog()) {
            this.handlerRegister.register(new LogHandler(this.getManager(), this.config));
        }
        if (this.config.isEnableNativeJsonLog()) {
            this.handlerRegister.register(new JsonLogHandler(this.getManager(), this.config));
        }
        this.handlerRegister.start();
    }

    public void notifyAfterCompleted() throws ServiceNotProvidedException {
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "agent-analyzer", "log-analyzer", "core"};
    }
}

