/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.KafkaHandler;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.server.pool.CustomThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaFetcherHandlerRegister {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaFetcherHandlerRegister.class);
    private ImmutableMap.Builder<String, KafkaHandler> builder = ImmutableMap.builder();
    private ImmutableMap<String, KafkaHandler> handlerMap;
    private final KafkaFetcherConfig config;
    private final Properties properties;
    private final ThreadPoolExecutor executor;
    private final boolean enableKafkaMessageAutoCommit;
    private final List<KafkaConsumer<String, Bytes>> consumers = Lists.newArrayList();

    public KafkaFetcherHandlerRegister(KafkaFetcherConfig config) {
        this.config = config;
        this.properties = new Properties();
        this.properties.setProperty("group.id", config.getGroupId());
        this.properties.setProperty("bootstrap.servers", config.getBootstrapServers());
        this.properties.putAll((Map<?, ?>)config.getKafkaConsumerConfig());
        int threadPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        if (config.getKafkaHandlerThreadPoolSize() > 0) {
            threadPoolSize = config.getKafkaHandlerThreadPoolSize();
        }
        int threadPoolQueueSize = 10000;
        if (config.getKafkaHandlerThreadPoolQueueSize() > 0) {
            threadPoolQueueSize = config.getKafkaHandlerThreadPoolQueueSize();
        }
        this.enableKafkaMessageAutoCommit = (Boolean)this.properties.getOrDefault((Object)"enable.auto.commit", (Object)true);
        for (int i = 0; i < config.getConsumers(); ++i) {
            KafkaConsumer consumer = new KafkaConsumer(this.properties, (Deserializer)new StringDeserializer(), (Deserializer)new BytesDeserializer());
            this.consumers.add((KafkaConsumer<String, Bytes>)consumer);
        }
        this.executor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadPoolQueueSize), (ThreadFactory)new CustomThreadFactory("KafkaConsumer"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void register(KafkaHandler handler) {
        this.builder.put((Object)handler.getTopic(), (Object)handler);
    }

    public void start() throws ModuleStartException {
        this.handlerMap = this.builder.build();
        this.builder = null;
        this.createTopicIfNeeded((Collection<String>)this.handlerMap.keySet(), this.properties);
        for (KafkaConsumer<String, Bytes> consumer : this.consumers) {
            consumer.subscribe((Collection)this.handlerMap.keySet());
            consumer.seekToEnd((Collection)consumer.assignment());
            this.executor.submit(() -> this.runTask(consumer));
        }
    }

    private void runTask(KafkaConsumer<String, Bytes> consumer) {
        while (true) {
            try {
                while (true) {
                    ConsumerRecords consumerRecords;
                    if ((consumerRecords = consumer.poll(Duration.ofMillis(500L))).isEmpty()) {
                        continue;
                    }
                    for (ConsumerRecord record : consumerRecords) {
                        this.executor.submit(() -> ((KafkaHandler)Objects.requireNonNull(this.handlerMap.get((Object)record.topic()))).handle((ConsumerRecord<String, Bytes>)record));
                    }
                    if (this.enableKafkaMessageAutoCommit) continue;
                    consumer.commitAsync();
                }
            }
            catch (Exception e) {
                log.error("Kafka handle message error.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void createTopicIfNeeded(Collection<String> topics, Properties properties) throws ModuleStartException {
        Properties adminProps = new Properties();
        adminProps.putAll((Map<?, ?>)properties);
        adminProps.remove("group.id");
        AdminClient adminClient = AdminClient.create((Properties)adminProps);
        Set missedTopics = adminClient.describeTopics(topics).values().entrySet().stream().map(entry -> {
            try {
                ((KafkaFuture)entry.getValue()).get();
                return null;
            }
            catch (InterruptedException | ExecutionException exception) {
                return (String)entry.getKey();
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!missedTopics.isEmpty()) {
            log.info("Topics " + missedTopics + " not exist.");
            List newTopicList = missedTopics.stream().map(topic -> new NewTopic(topic, this.config.getPartitions(), (short)this.config.getReplicationFactor())).collect(Collectors.toList());
            try {
                adminClient.createTopics(newTopicList).all().get();
            }
            catch (Exception e) {
                throw new ModuleStartException("Failed to create Kafka Topics" + missedTopics + ".", (Throwable)e);
            }
        }
    }
}

