/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.prometheus.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.BlockingQueue;
import org.apache.skywalking.oap.server.fetcher.prometheus.http.HTTPClientHandler;

public class HTTPClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private final BlockingQueue<String> channel;

    public HTTPClientInitializer(SslContext sslCtx, BlockingQueue<String> channel) {
        this.sslCtx = sslCtx;
        this.channel = channel;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        p.addLast(new ChannelHandler[]{new HttpClientCodec()});
        p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        p.addLast(new ChannelHandler[]{new HTTPClientHandler(this.channel)});
    }
}

