/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.prometheus.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.BlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientHandler
extends SimpleChannelInboundHandler<HttpObject> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPClientHandler.class);
    private final BlockingQueue<String> channel;
    private final StringBuilder buf = new StringBuilder();

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpResponse) {
            this.buf.setLength(0);
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.buf.append(content.content().toString(CharsetUtil.UTF_8));
            if (content instanceof LastHttpContent) {
                try {
                    this.channel.put(this.buf.toString());
                }
                catch (InterruptedException e) {
                    ctx.fireExceptionCaught((Throwable)e);
                }
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("HTTP request error", cause);
        ctx.close();
    }

    @Generated
    public HTTPClientHandler(BlockingQueue<String> channel) {
        this.channel = channel;
    }
}

