/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLMutationResolver;
import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.skywalking.oap.query.graphql.GraphQLQueryConfig;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplateManagementService;
import org.apache.skywalking.oap.server.core.query.input.DashboardSetting;
import org.apache.skywalking.oap.server.core.query.input.NewDashboardSetting;
import org.apache.skywalking.oap.server.core.query.type.DashboardConfiguration;
import org.apache.skywalking.oap.server.core.query.type.TemplateChangeStatus;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class UIConfigurationManagement
implements GraphQLQueryResolver,
GraphQLMutationResolver {
    private final ModuleManager manager;
    private UITemplateManagementService uiTemplateManagementService;
    private final GraphQLQueryConfig config;

    private UITemplateManagementService getUITemplateManagementService() {
        if (this.uiTemplateManagementService == null) {
            this.uiTemplateManagementService = (UITemplateManagementService)this.manager.find("core").provider().getService(UITemplateManagementService.class);
        }
        return this.uiTemplateManagementService;
    }

    public DashboardConfiguration getTemplate(String id) throws IOException {
        return this.getUITemplateManagementService().getTemplate(id);
    }

    public List<DashboardConfiguration> getAllTemplates() throws IOException {
        return this.getUITemplateManagementService().getAllTemplates(Boolean.valueOf(false));
    }

    public TemplateChangeStatus addTemplate(NewDashboardSetting setting) throws IOException {
        if (!this.config.isEnableUpdateUITemplate()) {
            return TemplateChangeStatus.builder().status(false).id("").message("The dashboard creation has been disabled. Check SW_ENABLE_UPDATE_UI_TEMPLATE on configuration-vocabulary.md(https://skywalking.apache.org/docs/main/latest/en/setup/backend/configuration-vocabulary/#configuration-vocabulary) to activate it.").build();
        }
        DashboardSetting dashboardSetting = new DashboardSetting();
        dashboardSetting.setId(UUID.randomUUID().toString());
        dashboardSetting.setConfiguration(setting.getConfiguration());
        return this.getUITemplateManagementService().addTemplate(dashboardSetting);
    }

    public TemplateChangeStatus changeTemplate(DashboardSetting setting) throws IOException {
        if (!this.config.isEnableUpdateUITemplate()) {
            return TemplateChangeStatus.builder().status(false).id(setting.getId()).message("The dashboard update has been disabled. Check SW_ENABLE_UPDATE_UI_TEMPLATE on configuration-vocabulary.md(https://skywalking.apache.org/docs/main/latest/en/setup/backend/configuration-vocabulary/#configuration-vocabulary) to activate it.").build();
        }
        return this.getUITemplateManagementService().changeTemplate(setting);
    }

    public TemplateChangeStatus disableTemplate(String id) throws IOException {
        if (!this.config.isEnableUpdateUITemplate()) {
            return TemplateChangeStatus.builder().status(false).id(id).message("The dashboard disable has been disabled. Check SW_ENABLE_UPDATE_UI_TEMPLATE on configuration-vocabulary.md(https://skywalking.apache.org/docs/main/latest/en/setup/backend/configuration-vocabulary/#configuration-vocabulary) to activate it.").build();
        }
        return this.getUITemplateManagementService().disableTemplate(id);
    }

    @Generated
    public UIConfigurationManagement(ModuleManager manager, GraphQLQueryConfig config) {
        this.manager = manager;
        this.config = config;
    }
}

