/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.io.IOException;
import java.util.List;
import org.apache.skywalking.oap.server.core.profiling.ebpf.EBPFProfilingQueryService;
import org.apache.skywalking.oap.server.core.profiling.ebpf.storage.EBPFProfilingTargetType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzation;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeAggregateType;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingAnalyzeTimeRange;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTask;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingTaskPrepare;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EBPFProcessProfilingQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private EBPFProfilingQueryService queryService;

    public EBPFProcessProfilingQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public EBPFProfilingQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (EBPFProfilingQueryService)this.moduleManager.find("core").provider().getService(EBPFProfilingQueryService.class);
        }
        return this.queryService;
    }

    public EBPFProfilingTaskPrepare queryPrepareCreateEBPFProfilingTaskData(String serviceId) throws IOException {
        if (StringUtil.isEmpty((String)serviceId)) {
            throw new IllegalArgumentException("please provide the service id");
        }
        return this.getQueryService().queryPrepareCreateEBPFProfilingTaskData(serviceId);
    }

    public List<EBPFProfilingTask> queryEBPFProfilingTasks(String serviceId, String serviceInstanceId, List<EBPFProfilingTargetType> targets) throws IOException {
        if (StringUtil.isEmpty((String)serviceId) && StringUtil.isEmpty((String)serviceInstanceId)) {
            throw new IllegalArgumentException("please provide the service id or instance id");
        }
        return this.getQueryService().queryEBPFProfilingTasks(serviceId, serviceInstanceId, targets);
    }

    public List<EBPFProfilingSchedule> queryEBPFProfilingSchedules(String taskId) throws IOException {
        return this.getQueryService().queryEBPFProfilingSchedules(taskId);
    }

    public EBPFProfilingAnalyzation analysisEBPFProfilingResult(List<String> scheduleIdList, List<EBPFProfilingAnalyzeTimeRange> timeRanges, EBPFProfilingAnalyzeAggregateType aggregateType) throws IOException {
        return this.getQueryService().getEBPFProfilingAnalyzation(scheduleIdList, timeRanges, aggregateType);
    }
}

