/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.logging.LoggingDecoratorBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogLevelMapper;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.ResponseLogLevelMapper;
import com.linecorp.armeria.common.util.Sampler;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.logging.LoggingService;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.slf4j.Logger;

public final class LoggingServiceBuilder
extends LoggingDecoratorBuilder {
    private Sampler<? super ServiceRequestContext> successSampler = Sampler.always();
    private Sampler<? super ServiceRequestContext> failureSampler = Sampler.always();

    LoggingServiceBuilder() {
    }

    public LoggingServiceBuilder sampler(Sampler<? super ServiceRequestContext> sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.successSampler = sampler;
        this.failureSampler = sampler;
        return this;
    }

    public LoggingServiceBuilder samplingRate(float samplingRate) {
        Preconditions.checkArgument(0.0 <= (double)samplingRate && (double)samplingRate <= 1.0, "samplingRate: %s (expected: 0.0 <= samplingRate <= 1.0)", (Object)Float.valueOf(samplingRate));
        return this.sampler(Sampler.random(samplingRate));
    }

    public LoggingServiceBuilder successSampler(Sampler<? super ServiceRequestContext> successSampler) {
        this.successSampler = Objects.requireNonNull(successSampler, "successSampler");
        return this;
    }

    public LoggingServiceBuilder successSamplingRate(float successSamplingRate) {
        Preconditions.checkArgument(0.0 <= (double)successSamplingRate && (double)successSamplingRate <= 1.0, "successSamplingRate: %s (expected: 0.0 <= successSamplingRate <= 1.0)", (Object)Float.valueOf(successSamplingRate));
        return this.successSampler(Sampler.random(successSamplingRate));
    }

    public LoggingServiceBuilder failureSampler(Sampler<? super ServiceRequestContext> failureSampler) {
        this.failureSampler = Objects.requireNonNull(failureSampler, "failureSampler");
        return this;
    }

    public LoggingServiceBuilder failureSamplingRate(float failureSamplingRate) {
        Preconditions.checkArgument(0.0 <= (double)failureSamplingRate && (double)failureSamplingRate <= 1.0, "failureSamplingRate: %s (expected: 0.0 <= failureSamplingRate <= 1.0)", (Object)Float.valueOf(failureSamplingRate));
        return this.failureSampler(Sampler.random(failureSamplingRate));
    }

    public LoggingService build(HttpService delegate) {
        return new LoggingService(delegate, this.logger(), this.requestLogLevelMapper(), this.responseLogLevelMapper(), this.requestHeadersSanitizer(), this.requestContentSanitizer(), this.requestTrailersSanitizer(), this.responseHeadersSanitizer(), this.responseContentSanitizer(), this.responseTrailersSanitizer(), this.responseCauseSanitizer(), this.successSampler, this.failureSampler);
    }

    public Function<? super HttpService, LoggingService> newDecorator() {
        return this::build;
    }

    @Override
    public LoggingServiceBuilder logger(Logger logger) {
        return (LoggingServiceBuilder)super.logger(logger);
    }

    @Override
    public LoggingServiceBuilder logger(String loggerName) {
        return (LoggingServiceBuilder)super.logger(loggerName);
    }

    @Override
    public LoggingServiceBuilder requestLogLevel(LogLevel requestLogLevel) {
        return (LoggingServiceBuilder)super.requestLogLevel(requestLogLevel);
    }

    @Override
    @Deprecated
    public LoggingServiceBuilder requestLogLevelMapper(Function<? super RequestOnlyLog, LogLevel> requestLogLevelMapper) {
        return (LoggingServiceBuilder)super.requestLogLevelMapper(requestLogLevelMapper);
    }

    @Override
    public LoggingServiceBuilder requestLogLevelMapper(RequestLogLevelMapper requestLogLevelMapper) {
        return (LoggingServiceBuilder)super.requestLogLevelMapper(requestLogLevelMapper);
    }

    @Override
    public LoggingServiceBuilder responseLogLevel(HttpStatus status, LogLevel logLevel) {
        return (LoggingServiceBuilder)super.responseLogLevel(status, logLevel);
    }

    @Override
    public LoggingServiceBuilder responseLogLevel(HttpStatusClass statusClass, LogLevel logLevel) {
        return (LoggingServiceBuilder)super.responseLogLevel(statusClass, logLevel);
    }

    @Override
    public LoggingServiceBuilder successfulResponseLogLevel(LogLevel successfulResponseLogLevel) {
        return (LoggingServiceBuilder)super.successfulResponseLogLevel(successfulResponseLogLevel);
    }

    @Override
    public LoggingServiceBuilder failureResponseLogLevel(LogLevel failureResponseLogLevel) {
        return (LoggingServiceBuilder)super.failureResponseLogLevel(failureResponseLogLevel);
    }

    @Override
    @Deprecated
    public LoggingServiceBuilder responseLogLevelMapper(Function<? super RequestLog, LogLevel> responseLogLevelMapper) {
        return (LoggingServiceBuilder)super.responseLogLevelMapper(responseLogLevelMapper);
    }

    @Override
    public LoggingServiceBuilder responseLogLevelMapper(ResponseLogLevelMapper responseLogLevelMapper) {
        return (LoggingServiceBuilder)super.responseLogLevelMapper(responseLogLevelMapper);
    }

    @Override
    public LoggingServiceBuilder requestHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestHeadersSanitizer) {
        return (LoggingServiceBuilder)super.requestHeadersSanitizer(requestHeadersSanitizer);
    }

    @Override
    public LoggingServiceBuilder responseHeadersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseHeadersSanitizer) {
        return (LoggingServiceBuilder)super.responseHeadersSanitizer(responseHeadersSanitizer);
    }

    @Override
    public LoggingServiceBuilder requestTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> requestTrailersSanitizer) {
        return (LoggingServiceBuilder)super.requestTrailersSanitizer(requestTrailersSanitizer);
    }

    @Override
    public LoggingServiceBuilder responseTrailersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> responseTrailersSanitizer) {
        return (LoggingServiceBuilder)super.responseTrailersSanitizer(responseTrailersSanitizer);
    }

    @Override
    public LoggingServiceBuilder headersSanitizer(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> headersSanitizer) {
        return (LoggingServiceBuilder)super.headersSanitizer(headersSanitizer);
    }

    @Override
    public LoggingServiceBuilder requestContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> requestContentSanitizer) {
        return (LoggingServiceBuilder)super.requestContentSanitizer(requestContentSanitizer);
    }

    @Override
    public LoggingServiceBuilder responseContentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> responseContentSanitizer) {
        return (LoggingServiceBuilder)super.responseContentSanitizer(responseContentSanitizer);
    }

    @Override
    public LoggingServiceBuilder contentSanitizer(BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer) {
        return (LoggingServiceBuilder)super.contentSanitizer(contentSanitizer);
    }

    @Override
    public LoggingServiceBuilder responseCauseSanitizer(BiFunction<? super RequestContext, ? super Throwable, ? extends @Nullable Object> responseCauseSanitizer) {
        return (LoggingServiceBuilder)super.responseCauseSanitizer(responseCauseSanitizer);
    }
}

