/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.ContentPreviewer;
import com.linecorp.armeria.common.logging.ContentPreviewerFactory;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.logging.ContentPreviewingUtil;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.logging.ContentPreviewingServiceBuilder;
import io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ContentPreviewingService
extends SimpleDecoratingHttpService {
    private static final AttributeKey<Boolean> SETTING_CONTENT_PREVIEW = AttributeKey.valueOf(ContentPreviewingService.class, (String)"SETTING_CONTENT_PREVIEW");
    private final ContentPreviewerFactory contentPreviewerFactory;
    private final BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer;
    private final BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer;

    public static Function<? super HttpService, ContentPreviewingService> newDecorator(int maxLength) {
        ContentPreviewerFactory factory = ContentPreviewerFactory.text(maxLength);
        return ContentPreviewingService.builder(factory).newDecorator();
    }

    public static Function<? super HttpService, ContentPreviewingService> newDecorator(int maxLength, Charset defaultCharset) {
        ContentPreviewerFactory factory = ContentPreviewerFactory.text(maxLength, defaultCharset);
        return ContentPreviewingService.builder(factory).newDecorator();
    }

    public static Function<? super HttpService, ContentPreviewingService> newDecorator(ContentPreviewerFactory contentPreviewerFactory) {
        return ContentPreviewingService.builder(contentPreviewerFactory).newDecorator();
    }

    public static ContentPreviewingServiceBuilder builder(ContentPreviewerFactory contentPreviewerFactory) {
        return new ContentPreviewingServiceBuilder(Objects.requireNonNull(contentPreviewerFactory, "contentPreviewerFactory"));
    }

    ContentPreviewingService(HttpService delegate, ContentPreviewerFactory contentPreviewerFactory, BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer, BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer) {
        super(delegate);
        this.contentPreviewerFactory = contentPreviewerFactory;
        this.requestPreviewSanitizer = requestPreviewSanitizer;
        this.responsePreviewSanitizer = responsePreviewSanitizer;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Boolean settingContentPreview = ctx.attr(SETTING_CONTENT_PREVIEW);
        if (Boolean.TRUE.equals(settingContentPreview)) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        ctx.setAttr(SETTING_CONTENT_PREVIEW, true);
        ContentPreviewer requestContentPreviewer = this.contentPreviewerFactory.requestContentPreviewer(ctx, req.headers());
        req = ContentPreviewingUtil.setUpRequestContentPreviewer(ctx, req, requestContentPreviewer, this.requestPreviewSanitizer);
        ctx.logBuilder().defer(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
        HttpResponse res = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        return ContentPreviewingUtil.setUpResponseContentPreviewer(this.contentPreviewerFactory, ctx, res, this.responsePreviewSanitizer);
    }
}

