/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.encoding.HttpEncoders;
import com.linecorp.armeria.server.encoding.HttpEncodingType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpEncodedResponse
extends FilteredHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(HttpEncodedResponse.class);
    private final HttpEncodingType encodingType;
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final long minBytesToForceChunkedAndEncoding;
    @Nullable
    private ByteArrayOutputStream encodedStream;
    @Nullable
    private OutputStream encodingStream;
    private boolean headersSent;
    private boolean encoderClosed;

    HttpEncodedResponse(HttpResponse delegate, HttpEncodingType encodingType, Predicate<MediaType> encodableContentTypePredicate, long minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodingType = encodingType;
        this.encodableContentTypePredicate = encodableContentTypePredicate;
        this.minBytesToForceChunkedAndEncoding = minBytesToForceChunkedAndEncoding;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof ResponseHeaders) {
            ResponseHeaders headers = (ResponseHeaders)obj;
            HttpStatus status = headers.status();
            if (status.isInformational()) {
                return obj;
            }
            if (this.headersSent) {
                return obj;
            }
            this.headersSent = true;
            if (!this.shouldEncodeResponse(headers)) {
                return obj;
            }
            this.encodedStream = new ByteArrayOutputStream();
            this.encodingStream = HttpEncoders.getEncodingOutputStream(this.encodingType, this.encodedStream);
            ResponseHeadersBuilder mutable = headers.toBuilder();
            mutable.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            switch (this.encodingType) {
                case GZIP: {
                    mutable.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, "gzip");
                    break;
                }
                case DEFLATE: {
                    mutable.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, "deflate");
                    break;
                }
                case BROTLI: {
                    mutable.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, "br");
                }
            }
            mutable.set((CharSequence)HttpHeaderNames.VARY, HttpHeaderNames.ACCEPT_ENCODING.toString());
            return mutable.build();
        }
        if (obj instanceof HttpHeaders) {
            return obj;
        }
        if (this.encodingStream == null) {
            return obj;
        }
        HttpData data = (HttpData)obj;
        assert (this.encodedStream != null);
        try {
            this.encodingStream.write(data.array());
            this.encodingStream.flush();
            HttpData status = HttpData.wrap(this.encodedStream.toByteArray());
            return status;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding HttpData, this should not happen with byte arrays.", e);
        }
        finally {
            this.encodedStream.reset();
        }
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        this.closeEncoder();
        if (this.encodedStream != null && this.encodedStream.size() > 0) {
            try {
                subscriber.onNext((Object)HttpData.wrap(this.encodedStream.toByteArray()));
            }
            catch (Throwable t) {
                subscriber.onError(t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onNext() should not raise an exception. subscriber: {}", subscriber, (Object)t);
            }
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        this.closeEncoder();
        return cause;
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        this.closeEncoder();
    }

    private void closeEncoder() {
        if (this.encoderClosed) {
            return;
        }
        this.encoderClosed = true;
        if (this.encodingStream == null) {
            return;
        }
        try {
            this.encodingStream.close();
        }
        catch (IOException e) {
            logger.warn("Unexpected exception is raised while closing the encoding stream.", (Throwable)e);
        }
    }

    private boolean shouldEncodeResponse(ResponseHeaders headers) {
        long contentLength;
        if (headers.status().isContentAlwaysEmpty()) {
            return false;
        }
        if (headers.contains((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) {
            return false;
        }
        if (headers.contentType() != null) {
            try {
                MediaType contentType = headers.contentType();
                if (!this.encodableContentTypePredicate.test(contentType)) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ((contentLength = headers.contentLength()) == -1L) {
            contentLength = Long.MAX_VALUE;
        }
        return contentLength >= this.minBytesToForceChunkedAndEncoding;
    }
}

