/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.FilteredHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.encoding.StreamDecoder;
import com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Subscriber;

final class HttpDecodedRequest
extends FilteredHttpRequest {
    private final StreamDecoder responseDecoder;
    private boolean decoderFinished;

    HttpDecodedRequest(HttpRequest delegate, StreamDecoderFactory decoderFactory, ByteBufAllocator alloc) {
        super(delegate);
        this.responseDecoder = decoderFactory.newDecoder(alloc);
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpData) {
            return this.responseDecoder.decode((HttpData)obj);
        }
        return obj;
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData == null) {
            return;
        }
        if (!lastData.isEmpty()) {
            subscriber.onNext((Object)lastData);
        } else {
            lastData.close();
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData != null) {
            lastData.close();
        }
        return cause;
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData != null) {
            lastData.close();
        }
    }

    @Nullable
    private HttpData closeResponseDecoder() {
        if (this.decoderFinished) {
            return null;
        }
        this.decoderFinished = true;
        return this.responseDecoder.finish();
    }
}

