/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.encoding;

import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.encoding.EncodingServiceBuilder;
import com.linecorp.armeria.server.encoding.HttpEncodedResponse;
import com.linecorp.armeria.server.encoding.HttpEncoders;
import com.linecorp.armeria.server.encoding.HttpEncodingType;
import java.util.function.Function;
import java.util.function.Predicate;

public final class EncodingService
extends SimpleDecoratingHttpService {
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final Predicate<? super RequestHeaders> encodableRequestHeadersPredicate;
    private final long minBytesToForceChunkedAndEncoding;

    public static EncodingServiceBuilder builder() {
        return new EncodingServiceBuilder();
    }

    public static Function<? super HttpService, EncodingService> newDecorator() {
        return EncodingService.builder().newDecorator();
    }

    EncodingService(HttpService delegate, Predicate<MediaType> encodableContentTypePredicate, Predicate<? super RequestHeaders> encodableRequestHeadersPredicate, long minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodableContentTypePredicate = encodableContentTypePredicate;
        this.encodableRequestHeadersPredicate = encodableRequestHeadersPredicate;
        this.minBytesToForceChunkedAndEncoding = minBytesToForceChunkedAndEncoding;
    }

    @Override
    public ExchangeType exchangeType(RequestHeaders headers, Route route) {
        return ExchangeType.BIDI_STREAMING;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpEncodingType encodingType = HttpEncoders.getWrapperForRequest(req);
        HttpResponse delegateResponse = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        if (encodingType == null || !this.encodableRequestHeadersPredicate.test(req.headers())) {
            return delegateResponse;
        }
        return new HttpEncodedResponse(delegateResponse, encodingType, this.encodableContentTypePredicate, this.minBytesToForceChunkedAndEncoding);
    }
}

