/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.TypeSignatureJsonSerializer;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonSerialize(using=TypeSignatureJsonSerializer.class)
public final class TypeSignature {
    private static final Pattern BASE_PATTERN = Pattern.compile("^([^.<>]+)$");
    private static final Pattern NAMED_PATTERN = Pattern.compile("^([^.<>]+(?:\\.[^.<>]+)+)$");
    private final String name;
    @Nullable
    private final Object namedTypeDescriptor;
    private final List<TypeSignature> typeParameters;

    public static TypeSignature ofBase(String baseTypeName) {
        TypeSignature.checkBaseTypeName(baseTypeName, "baseTypeName");
        return new TypeSignature(baseTypeName, ImmutableList.of());
    }

    public static TypeSignature ofContainer(String containerTypeName, TypeSignature ... elementTypeSignatures) {
        Objects.requireNonNull(elementTypeSignatures, "elementTypeSignatures");
        return TypeSignature.ofContainer(containerTypeName, ImmutableList.copyOf(elementTypeSignatures));
    }

    public static TypeSignature ofContainer(String containerTypeName, Iterable<TypeSignature> elementTypeSignatures) {
        TypeSignature.checkBaseTypeName(containerTypeName, "containerTypeName");
        Objects.requireNonNull(elementTypeSignatures, "elementTypeSignatures");
        ImmutableList<TypeSignature> elementTypeSignaturesCopy = ImmutableList.copyOf(elementTypeSignatures);
        Preconditions.checkArgument(!elementTypeSignaturesCopy.isEmpty(), "elementTypeSignatures is empty.");
        return new TypeSignature(containerTypeName, elementTypeSignaturesCopy);
    }

    private static void checkBaseTypeName(String baseTypeName, String parameterName) {
        Objects.requireNonNull(baseTypeName, parameterName);
        Preconditions.checkArgument(BASE_PATTERN.matcher(baseTypeName).matches(), "%s: %s", (Object)parameterName, (Object)baseTypeName);
    }

    public static TypeSignature ofList(TypeSignature elementTypeSignature) {
        Objects.requireNonNull(elementTypeSignature, "elementTypeSignature");
        return TypeSignature.ofContainer("list", elementTypeSignature);
    }

    public static TypeSignature ofList(Class<?> namedElementType) {
        return TypeSignature.ofList(TypeSignature.ofNamed(namedElementType, "namedElementType"));
    }

    public static TypeSignature ofSet(TypeSignature elementTypeSignature) {
        Objects.requireNonNull(elementTypeSignature, "elementTypeSignature");
        return TypeSignature.ofContainer("set", elementTypeSignature);
    }

    public static TypeSignature ofSet(Class<?> namedElementType) {
        return TypeSignature.ofSet(TypeSignature.ofNamed(namedElementType, "namedElementType"));
    }

    public static TypeSignature ofMap(TypeSignature keyTypeSignature, TypeSignature valueTypeSignature) {
        Objects.requireNonNull(keyTypeSignature, "keyTypeSignature");
        Objects.requireNonNull(valueTypeSignature, "valueTypeSignature");
        return TypeSignature.ofContainer("map", keyTypeSignature, valueTypeSignature);
    }

    public static TypeSignature ofMap(Class<?> namedKeyType, Class<?> namedValueType) {
        return TypeSignature.ofMap(TypeSignature.ofNamed(namedKeyType, "namedKeyType"), TypeSignature.ofNamed(namedValueType, "namedValueType"));
    }

    public static TypeSignature ofNamed(Class<?> namedType) {
        return TypeSignature.ofNamed(namedType, "namedType");
    }

    public static TypeSignature ofNamed(String name, Object namedTypeDescriptor) {
        return new TypeSignature(Objects.requireNonNull(name, "name"), Objects.requireNonNull(namedTypeDescriptor, "namedTypeDescriptor"));
    }

    private static TypeSignature ofNamed(Class<?> namedType, String parameterName) {
        Objects.requireNonNull(namedType, parameterName);
        String typeName = namedType.getName();
        Preconditions.checkArgument(NAMED_PATTERN.matcher(typeName).matches(), "%s: %s", (Object)parameterName, (Object)typeName);
        Preconditions.checkArgument(!namedType.isArray(), "%s is an array: %s", (Object)parameterName, (Object)typeName);
        Preconditions.checkArgument(!namedType.isPrimitive(), "%s is a primitive type: %s", (Object)parameterName, (Object)typeName);
        return new TypeSignature(namedType);
    }

    public static TypeSignature ofUnresolved(String unresolvedTypeName) {
        Objects.requireNonNull(unresolvedTypeName, "unresolvedTypeName");
        return new TypeSignature('?' + unresolvedTypeName, ImmutableList.of());
    }

    private TypeSignature(String name, List<TypeSignature> typeParameters) {
        this.name = name;
        this.typeParameters = typeParameters;
        this.namedTypeDescriptor = null;
    }

    private TypeSignature(Class<?> namedTypeDescriptor) {
        this.name = namedTypeDescriptor.getName();
        this.namedTypeDescriptor = namedTypeDescriptor;
        this.typeParameters = ImmutableList.of();
    }

    private TypeSignature(String name, Object namedTypeDescriptor) {
        this.name = name;
        this.namedTypeDescriptor = namedTypeDescriptor;
        this.typeParameters = ImmutableList.of();
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Object namedTypeDescriptor() {
        return this.namedTypeDescriptor;
    }

    public List<TypeSignature> typeParameters() {
        return this.typeParameters;
    }

    public String signature() {
        if (this.typeParameters.isEmpty()) {
            return this.name;
        }
        return this.name + '<' + Joiner.on(", ").join(this.typeParameters) + '>';
    }

    public boolean isBase() {
        return !this.isUnresolved() && !this.isNamed() && !this.isContainer();
    }

    public boolean isContainer() {
        return !this.typeParameters.isEmpty();
    }

    public boolean isNamed() {
        return this.namedTypeDescriptor != null;
    }

    public boolean isUnresolved() {
        return this.name.startsWith("?");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeSignature)) {
            return false;
        }
        TypeSignature that = (TypeSignature)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Objects.equals(this.namedTypeDescriptor, that.namedTypeDescriptor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namedTypeDescriptor, this.typeParameters);
    }

    public String toString() {
        return this.signature();
    }
}

