/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ServiceInfo {
    private final String name;
    private final Set<MethodInfo> methods;
    private final List<HttpHeaders> exampleHeaders;
    @Nullable
    private final String docString;

    public ServiceInfo(String name, Iterable<MethodInfo> methods) {
        this(name, methods, null);
    }

    public ServiceInfo(String name, Iterable<MethodInfo> methods, @Nullable String docString) {
        this(name, methods, ImmutableList.of(), docString);
    }

    public ServiceInfo(String name, Iterable<MethodInfo> methods, Iterable<HttpHeaders> exampleHeaders, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.methods = ServiceInfo.mergeEndpoints(Objects.requireNonNull(methods));
        this.exampleHeaders = ImmutableList.copyOf(Objects.requireNonNull(exampleHeaders, "exampleHeaders"));
        this.docString = Strings.emptyToNull(docString);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public Set<MethodInfo> methods() {
        return this.methods;
    }

    static Set<MethodInfo> mergeEndpoints(Iterable<MethodInfo> methodInfos) {
        HashMap<List, MethodInfo> methodInfoMap = new HashMap<List, MethodInfo>();
        for (MethodInfo methodInfo : methodInfos) {
            ImmutableList<HttpMethod> mergeKey = ImmutableList.of(methodInfo.name(), methodInfo.httpMethod());
            methodInfoMap.compute(mergeKey, (key, value) -> {
                if (value == null) {
                    return methodInfo;
                }
                Sets.SetView<EndpointInfo> endpointInfos = Sets.union(value.endpoints(), methodInfo.endpoints());
                return new MethodInfo(value.name(), value.returnTypeSignature(), value.parameters(), value.exceptionTypeSignatures(), endpointInfos, value.exampleHeaders(), value.exampleRequests(), value.examplePaths(), value.exampleQueries(), value.httpMethod(), value.docString());
            });
        }
        return ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(Comparator.comparing(MethodInfo::name).thenComparing(MethodInfo::httpMethod)).addAll((Iterable)methodInfoMap.values())).build();
    }

    public Set<TypeSignature> findNamedTypes() {
        HashSet collectedNamedTypes = new HashSet();
        this.methods().forEach(m -> {
            ServiceInfo.findNamedTypes(collectedNamedTypes, m.returnTypeSignature());
            m.parameters().forEach(p -> ServiceInfo.findNamedTypes(collectedNamedTypes, p.typeSignature()));
            m.exceptionTypeSignatures().forEach(s -> ServiceInfo.findNamedTypes(collectedNamedTypes, s));
        });
        return ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::name), collectedNamedTypes);
    }

    static void findNamedTypes(Set<TypeSignature> collectedNamedTypes, TypeSignature typeSignature) {
        if (typeSignature.isNamed()) {
            collectedNamedTypes.add(typeSignature);
        }
        if (typeSignature.isContainer()) {
            typeSignature.typeParameters().forEach(p -> ServiceInfo.findNamedTypes(collectedNamedTypes, p));
        }
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHeaders() {
        return this.exampleHeaders;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceInfo)) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)o;
        return this.name.equals(that.name) && this.methods.equals(that.methods);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.methods);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("methods", this.methods).add("exampleHeaders", this.exampleHeaders).add("docstring", this.docString).toString();
    }
}

