/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.PathAndQuery;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class MethodInfo {
    private final String name;
    private final TypeSignature returnTypeSignature;
    private final List<FieldInfo> parameters;
    private final Set<TypeSignature> exceptionTypeSignatures;
    private final Set<EndpointInfo> endpoints;
    private final List<HttpHeaders> exampleHeaders;
    private final List<String> exampleRequests;
    private final List<String> examplePaths;
    private final List<String> exampleQueries;
    private final HttpMethod httpMethod;
    @Nullable
    private final String docString;

    public MethodInfo(String name, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints, HttpMethod httpMethod, @Nullable String docString) {
        this(name, returnTypeSignature, parameters, exceptionTypeSignatures, endpoints, ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), ImmutableList.of(), httpMethod, docString);
    }

    public MethodInfo(String name, TypeSignature returnTypeSignature, Iterable<FieldInfo> parameters, Iterable<TypeSignature> exceptionTypeSignatures, Iterable<EndpointInfo> endpoints, Iterable<HttpHeaders> exampleHeaders, Iterable<String> exampleRequests, Iterable<String> examplePaths, Iterable<String> exampleQueries, HttpMethod httpMethod, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.returnTypeSignature = Objects.requireNonNull(returnTypeSignature, "returnTypeSignature");
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters"));
        this.exceptionTypeSignatures = ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::signature), Objects.requireNonNull(exceptionTypeSignatures, "exceptionTypeSignatures"));
        this.endpoints = ImmutableSortedSet.copyOf(Comparator.comparing(e -> e.hostnamePattern() + ':' + e.pathMapping()), Objects.requireNonNull(endpoints, "endpoints"));
        this.exampleHeaders = ImmutableList.copyOf(Objects.requireNonNull(exampleHeaders, "exampleHeaders"));
        this.exampleRequests = ImmutableList.copyOf(Objects.requireNonNull(exampleRequests, "exampleRequests"));
        Objects.requireNonNull(examplePaths, "examplePaths");
        ImmutableList.Builder examplePathsBuilder = ImmutableList.builderWithExpectedSize(Iterables.size(examplePaths));
        for (String path : examplePaths) {
            PathAndQuery pathAndQuery = PathAndQuery.parse(path);
            Preconditions.checkArgument(pathAndQuery != null, "examplePaths contains an invalid path: %s", (Object)path);
            examplePathsBuilder.add(pathAndQuery.path());
        }
        this.examplePaths = examplePathsBuilder.build();
        Objects.requireNonNull(exampleQueries, "exampleQueries");
        ImmutableList.Builder exampleQueriesBuilder = ImmutableList.builderWithExpectedSize(Iterables.size(exampleQueries));
        for (String query : exampleQueries) {
            PathAndQuery pathAndQuery = PathAndQuery.parse('?' + query);
            Preconditions.checkArgument(pathAndQuery != null, "exampleQueries contains an invalid query string: %s", (Object)query);
            exampleQueriesBuilder.add(pathAndQuery.query());
        }
        this.exampleQueries = exampleQueriesBuilder.build();
        this.httpMethod = Objects.requireNonNull(httpMethod, "httpMethod");
        this.docString = Strings.emptyToNull(docString);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public TypeSignature returnTypeSignature() {
        return this.returnTypeSignature;
    }

    @JsonProperty
    public Set<EndpointInfo> endpoints() {
        return this.endpoints;
    }

    @JsonProperty
    public List<FieldInfo> parameters() {
        return this.parameters;
    }

    @JsonProperty
    public Set<TypeSignature> exceptionTypeSignatures() {
        return this.exceptionTypeSignatures;
    }

    @JsonProperty
    public List<HttpHeaders> exampleHeaders() {
        return this.exampleHeaders;
    }

    @JsonProperty
    public List<String> exampleRequests() {
        return this.exampleRequests;
    }

    @JsonProperty
    public List<String> examplePaths() {
        return this.examplePaths;
    }

    @JsonProperty
    public List<String> exampleQueries() {
        return this.exampleQueries;
    }

    @JsonProperty
    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo that = (MethodInfo)o;
        return this.name().equals(that.name()) && this.returnTypeSignature().equals(that.returnTypeSignature()) && this.parameters().equals(that.parameters()) && this.exceptionTypeSignatures().equals(that.exceptionTypeSignatures()) && this.endpoints().equals(that.endpoints()) && this.httpMethod() == that.httpMethod();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name(), this.returnTypeSignature(), this.parameters(), this.exceptionTypeSignatures(), this.endpoints(), this.httpMethod()});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name()).add("returnTypeSignature", this.returnTypeSignature()).add("parameters", this.parameters()).add("exceptionTypeSignatures", this.exceptionTypeSignatures()).add("endpoints", this.endpoints()).add("httpMethod", (Object)this.httpMethod()).toString();
    }
}

