/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldLocation;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.List;
import java.util.Objects;

public final class FieldInfoBuilder {
    private final String name;
    private final TypeSignature typeSignature;
    private final List<FieldInfo> childFieldInfos;
    private FieldRequirement requirement = FieldRequirement.UNSPECIFIED;
    private FieldLocation location = FieldLocation.UNSPECIFIED;
    @Nullable
    private String docString;

    FieldInfoBuilder(String name, TypeSignature typeSignature) {
        this.name = Objects.requireNonNull(name, "name");
        this.typeSignature = Objects.requireNonNull(typeSignature, "typeSignature");
        this.childFieldInfos = ImmutableList.of();
    }

    FieldInfoBuilder(String name, TypeSignature typeSignature, FieldInfo ... childFieldInfos) {
        this(name, typeSignature, ImmutableList.copyOf(childFieldInfos));
    }

    FieldInfoBuilder(String name, TypeSignature typeSignature, Iterable<FieldInfo> childFieldInfos) {
        this.name = Objects.requireNonNull(name, "name");
        this.typeSignature = typeSignature;
        Preconditions.checkArgument(!Iterables.isEmpty(Objects.requireNonNull(childFieldInfos, "childFieldInfos")), "childFieldInfos can't be empty.");
        this.childFieldInfos = ImmutableList.copyOf(childFieldInfos);
    }

    public FieldInfoBuilder requirement(FieldRequirement requirement) {
        this.requirement = Objects.requireNonNull(requirement, "requirement");
        return this;
    }

    public FieldInfoBuilder location(FieldLocation location) {
        this.location = Objects.requireNonNull(location, "location");
        return this;
    }

    public FieldInfoBuilder docString(String docString) {
        this.docString = Objects.requireNonNull(docString, "docString");
        return this;
    }

    public FieldInfo build() {
        return new FieldInfo(this.name, this.location, this.requirement, this.typeSignature, this.childFieldInfos, this.docString);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("location", (Object)this.location).add("requirement", (Object)this.requirement).add("typeSignature", this.typeSignature).add("childFieldInfos", this.childFieldInfos).add("docString", this.docString).toString();
    }
}

