/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.FieldInfoBuilder;
import com.linecorp.armeria.server.docs.FieldLocation;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.List;
import java.util.Objects;

public final class FieldInfo {
    private final String name;
    private final FieldLocation location;
    private final FieldRequirement requirement;
    private final TypeSignature typeSignature;
    private final List<FieldInfo> childFieldInfos;
    @Nullable
    private final String docString;

    public static FieldInfo of(String name, TypeSignature typeSignature) {
        return new FieldInfo(name, FieldLocation.UNSPECIFIED, FieldRequirement.UNSPECIFIED, typeSignature, ImmutableList.of(), null);
    }

    public static FieldInfoBuilder builder(String name, TypeSignature typeSignature) {
        return new FieldInfoBuilder(name, typeSignature);
    }

    public static FieldInfoBuilder builder(String name, TypeSignature typeSignature, FieldInfo ... childFieldInfos) {
        return new FieldInfoBuilder(name, typeSignature, childFieldInfos);
    }

    public static FieldInfoBuilder builder(String name, TypeSignature typeSignature, Iterable<FieldInfo> childFieldInfos) {
        return new FieldInfoBuilder(name, typeSignature, childFieldInfos);
    }

    FieldInfo(String name, FieldLocation location, FieldRequirement requirement, TypeSignature typeSignature, List<FieldInfo> childFieldInfos, @Nullable String docString) {
        this.name = name;
        this.location = location;
        this.requirement = requirement;
        this.typeSignature = typeSignature;
        this.childFieldInfos = childFieldInfos;
        this.docString = docString;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public FieldLocation location() {
        return this.location;
    }

    @JsonProperty
    public FieldRequirement requirement() {
        return this.requirement;
    }

    @JsonProperty
    public TypeSignature typeSignature() {
        return this.typeSignature;
    }

    @JsonProperty
    public List<FieldInfo> childFieldInfos() {
        return this.childFieldInfos;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo that = (FieldInfo)o;
        return this.name.equals(that.name) && this.location == that.location && this.requirement == that.requirement && this.typeSignature.equals(that.typeSignature) && this.childFieldInfos.equals(that.childFieldInfos);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.location, this.requirement, this.typeSignature, this.childFieldInfos});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("location", (Object)this.location).add("requirement", (Object)this.requirement).add("typeSignature", this.typeSignature).add("childFieldInfos", this.childFieldInfos).add("docString", this.docString).toString();
    }
}

