/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ExceptionInfo
implements NamedTypeInfo {
    private final String name;
    private final List<FieldInfo> fields;
    @Nullable
    private final String docString;

    public ExceptionInfo(String name, Iterable<FieldInfo> fields) {
        this(name, fields, null);
    }

    public ExceptionInfo(String name, Iterable<FieldInfo> fields, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.fields = ImmutableList.copyOf(Objects.requireNonNull(fields, "fields"));
        this.docString = Strings.emptyToNull(docString);
    }

    @Override
    public String name() {
        return this.name;
    }

    @JsonProperty
    public List<FieldInfo> fields() {
        return this.fields;
    }

    @Override
    public String docString() {
        return this.docString;
    }

    @Override
    public Set<TypeSignature> findNamedTypes() {
        HashSet collectedNamedTypes = new HashSet();
        this.fields().forEach(f -> ServiceInfo.findNamedTypes(collectedNamedTypes, f.typeSignature()));
        return ImmutableSortedSet.copyOf(Comparator.comparing(TypeSignature::name), collectedNamedTypes);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExceptionInfo)) {
            return false;
        }
        ExceptionInfo that = (ExceptionInfo)o;
        return this.name.equals(that.name) && this.fields.equals(that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fields);
    }

    public String toString() {
        return this.name;
    }
}

