/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import java.util.Objects;

public final class EnumValueInfo {
    private final String name;
    @Nullable
    private final String docString;
    @Nullable
    private final Integer intValue;

    public EnumValueInfo(String name) {
        this(name, null, null);
    }

    public EnumValueInfo(String name, @Nullable Integer intValue) {
        this(name, intValue, null);
    }

    public EnumValueInfo(String name, @Nullable Integer intValue, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.intValue = intValue;
        this.docString = Strings.emptyToNull(docString);
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Integer intValue() {
        return this.intValue;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String docString() {
        return this.docString;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.intValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumValueInfo)) {
            return false;
        }
        EnumValueInfo that = (EnumValueInfo)o;
        return this.name.equals(that.name) && Objects.equals(this.intValue, that.intValue);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("intValue", this.intValue).add("docString", this.docString).toString();
    }
}

