/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class EnumInfo
implements NamedTypeInfo {
    private final String name;
    private final List<EnumValueInfo> values;
    @Nullable
    private final String docString;

    public EnumInfo(Class<? extends Enum<?>> enumType) {
        this(enumType.getName(), enumType);
    }

    public EnumInfo(Class<? extends Enum<?>> enumType, String docString) {
        this(enumType.getName(), enumType, Objects.requireNonNull(docString, "docString"));
    }

    public EnumInfo(String name, Class<? extends Enum<?>> enumType) {
        this(name, enumType, null);
    }

    public EnumInfo(String name, Class<? extends Enum<?>> enumType, @Nullable String docString) {
        this(name, EnumInfo.toEnumValues(enumType), docString);
    }

    public EnumInfo(String name, Iterable<EnumValueInfo> values) {
        this(name, values, null);
    }

    public EnumInfo(String name, Iterable<EnumValueInfo> values, @Nullable String docString) {
        this.name = Objects.requireNonNull(name, "name");
        this.values = ImmutableList.copyOf(Objects.requireNonNull(values, "values"));
        this.docString = Strings.emptyToNull(docString);
    }

    @Override
    public String name() {
        return this.name;
    }

    @JsonProperty
    public List<EnumValueInfo> values() {
        return this.values;
    }

    @Override
    public String docString() {
        return this.docString;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnumInfo)) {
            return false;
        }
        EnumInfo that = (EnumInfo)o;
        return this.name.equals(that.name) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String toString() {
        return this.name;
    }

    private static Iterable<EnumValueInfo> toEnumValues(Class<? extends Enum<?>> enumType) {
        Class<? extends Enum<?>> rawEnumType = Objects.requireNonNull(enumType, "enumType");
        EnumSet<Enum<?>> values = EnumSet.allOf(rawEnumType);
        return values.stream().map(e -> new EnumValueInfo(e.name()))::iterator;
    }
}

