/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.docs.EndpointInfo;
import java.util.Objects;
import java.util.Set;

public final class EndpointInfoBuilder {
    private final String hostnamePattern;
    private final String pathMapping;
    @Nullable
    private String regexPathPrefix;
    @Nullable
    private String fragment;
    @Nullable
    private MediaType defaultMimeType;
    @Nullable
    private Set<MediaType> availableMimeTypes;

    EndpointInfoBuilder(String hostnamePattern, String pathMapping) {
        this.hostnamePattern = Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        this.pathMapping = Objects.requireNonNull(pathMapping, "pathMapping");
    }

    public EndpointInfoBuilder regexPathPrefix(String regexPathPrefix) {
        Objects.requireNonNull(regexPathPrefix, "regexPathPrefix");
        Preconditions.checkState(this.fragment == null, "regexPathPrefix cannot be set with fragment: %s", this.fragment);
        this.regexPathPrefix = regexPathPrefix;
        return this;
    }

    public EndpointInfoBuilder fragment(String fragment) {
        Objects.requireNonNull(fragment, "fragment");
        Preconditions.checkState(this.regexPathPrefix == null, "fragment cannot be set with regexPathPrefix: %s", this.regexPathPrefix);
        this.fragment = fragment;
        return this;
    }

    public EndpointInfoBuilder defaultFormat(SerializationFormat defaultFormat) {
        Objects.requireNonNull(defaultFormat, "defaultFormat");
        return this.defaultMimeType(defaultFormat.mediaType());
    }

    public EndpointInfoBuilder defaultMimeType(MediaType defaultMimeType) {
        Objects.requireNonNull(defaultMimeType, "defaultMimeType");
        this.defaultMimeType = defaultMimeType;
        if (this.availableMimeTypes == null) {
            this.availableMimeTypes = ImmutableSet.of(defaultMimeType);
        } else if (!this.availableMimeTypes.contains(defaultMimeType)) {
            this.availableMimeTypes = EndpointInfoBuilder.addDefaultMimeType(defaultMimeType, this.availableMimeTypes);
        }
        return this;
    }

    private static Set<MediaType> addDefaultMimeType(MediaType defaultMimeType, Iterable<MediaType> availableMimeTypes) {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(defaultMimeType)).addAll(availableMimeTypes)).build();
    }

    public EndpointInfoBuilder availableFormats(SerializationFormat ... availableFormats) {
        Objects.requireNonNull(availableFormats, "availableFormats");
        return this.availableFormats(ImmutableSet.copyOf(availableFormats));
    }

    public EndpointInfoBuilder availableFormats(Iterable<SerializationFormat> availableFormats) {
        Objects.requireNonNull(availableFormats, "availableFormats");
        return this.availableMimeTypes(Streams.stream(availableFormats).map(SerializationFormat::mediaType).collect(ImmutableSet.toImmutableSet()));
    }

    public EndpointInfoBuilder availableMimeTypes(MediaType ... availableMimeTypes) {
        Objects.requireNonNull(availableMimeTypes, "availableMimeTypes");
        return this.availableMimeTypes(ImmutableSet.copyOf(availableMimeTypes));
    }

    public EndpointInfoBuilder availableMimeTypes(Iterable<MediaType> availableMimeTypes) {
        Objects.requireNonNull(availableMimeTypes, "availableMimeTypes");
        Preconditions.checkArgument(!Iterables.isEmpty(availableMimeTypes), "Should at least have an available media type.");
        this.availableMimeTypes = this.defaultMimeType != null && !Iterables.contains(availableMimeTypes, this.defaultMimeType) ? EndpointInfoBuilder.addDefaultMimeType(this.defaultMimeType, availableMimeTypes) : ImmutableSet.copyOf(availableMimeTypes);
        return this;
    }

    public EndpointInfo build() {
        Preconditions.checkState(this.availableMimeTypes != null && !this.availableMimeTypes.isEmpty(), "Should at least have an available media type.");
        return new EndpointInfo(this.hostnamePattern, this.pathMapping, this.regexPathPrefix, this.fragment, this.defaultMimeType, this.availableMimeTypes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("hostnamePattern", this.hostnamePattern).add("pathMapping", this.pathMapping).add("regexPathPrefix", this.regexPathPrefix).add("fragment", this.fragment).add("defaultMimeType", this.defaultMimeType).add("availableMimeTypes", this.availableMimeTypes).toString();
    }
}

