/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.docs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ServerCacheControl;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Version;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.ExceptionInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.AggregatedHttpFile;
import com.linecorp.armeria.server.file.FileService;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileBuilder;
import com.linecorp.armeria.server.file.HttpVfs;
import com.linecorp.armeria.server.file.MediaTypeResolver;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocService
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(DocService.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
    static final List<DocServicePlugin> plugins = ImmutableList.copyOf(ServiceLoader.load(DocServicePlugin.class, DocService.class.getClassLoader()));
    private final Map<String, ListMultimap<String, HttpHeaders>> exampleHeaders;
    private final Map<String, ListMultimap<String, String>> exampleRequests;
    private final Map<String, ListMultimap<String, String>> examplePaths;
    private final Map<String, ListMultimap<String, String>> exampleQueries;
    private final List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers;
    private final DocServiceFilter filter;
    @Nullable
    private Server server;

    public static DocServiceBuilder builder() {
        return new DocServiceBuilder();
    }

    public DocService() {
        this(ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(), DocServiceBuilder.ALL_SERVICES);
    }

    DocService(Map<String, ListMultimap<String, HttpHeaders>> exampleHeaders, Map<String, ListMultimap<String, String>> exampleRequests, Map<String, ListMultimap<String, String>> examplePaths, Map<String, ListMultimap<String, String>> exampleQueries, List<BiFunction<ServiceRequestContext, HttpRequest, String>> injectedScriptSuppliers, DocServiceFilter filter) {
        super(FileService.builder(new DocServiceVfs()).serveCompressedFiles(true).autoDecompress(true).build());
        this.exampleHeaders = DocService.immutableCopyOf(exampleHeaders, "exampleHeaders");
        this.exampleRequests = DocService.immutableCopyOf(exampleRequests, "exampleRequests");
        this.examplePaths = DocService.immutableCopyOf(examplePaths, "examplePaths");
        this.exampleQueries = DocService.immutableCopyOf(exampleQueries, "exampleQueries");
        this.injectedScriptSuppliers = Objects.requireNonNull(injectedScriptSuppliers, "injectedScriptSuppliers");
        this.filter = Objects.requireNonNull(filter, "filter");
    }

    private static <T> Map<String, ListMultimap<String, T>> immutableCopyOf(Map<String, ListMultimap<String, T>> map, String name) {
        Objects.requireNonNull(map, name);
        return map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableListMultimap.copyOf((Multimap)e.getValue())));
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        super.serviceAdded(cfg);
        if (this.server != null) {
            if (this.server != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.server = cfg.server();
        this.server.addListener(new ServerListenerAdapter(){

            @Override
            public void serverStarting(Server server) throws Exception {
                ServerConfig config = server.config();
                List<VirtualHost> virtualHosts = config.findVirtualHosts(DocService.this);
                List services = config.serviceConfigs().stream().filter(se -> virtualHosts.contains(se.virtualHost())).collect(ImmutableList.toImmutableList());
                ServiceSpecification spec = DocService.generate(services, DocService.this.filter);
                spec = DocService.addDocStrings(spec, services);
                spec = DocService.this.addExamples(spec);
                ImmutableList<Version> versions = ImmutableList.copyOf(Version.getAll(DocService.class.getClassLoader()).values());
                DocService.this.vfs().put("/specification.json", jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)spec));
                DocService.this.vfs().put("/versions.json", jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes(versions));
            }
        });
    }

    private static ServiceSpecification generate(List<ServiceConfig> services, DocServiceFilter filter) {
        return ServiceSpecification.merge(plugins.stream().map(plugin -> plugin.generateSpecification(DocService.findSupportedServices(plugin, services), filter)).collect(ImmutableList.toImmutableList()));
    }

    private static ServiceSpecification addDocStrings(ServiceSpecification spec, List<ServiceConfig> services) {
        Map docStrings = plugins.stream().flatMap(plugin -> plugin.loadDocStrings(DocService.findSupportedServices(plugin, services)).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
        return new ServiceSpecification(spec.services().stream().map(service -> DocService.addServiceDocStrings(service, docStrings)).collect(ImmutableList.toImmutableList()), spec.enums().stream().map(e -> DocService.addEnumDocStrings(e, docStrings)).collect(ImmutableList.toImmutableList()), spec.structs().stream().map(s -> DocService.addStructDocStrings(s, docStrings)).collect(ImmutableList.toImmutableList()), spec.exceptions().stream().map(e -> DocService.addExceptionDocStrings(e, docStrings)).collect(ImmutableList.toImmutableList()), spec.exampleHeaders());
    }

    private static ServiceInfo addServiceDocStrings(ServiceInfo service, Map<String, String> docStrings) {
        return new ServiceInfo(service.name(), service.methods().stream().map(method -> DocService.addMethodDocStrings(service, method, docStrings)).collect(ImmutableList.toImmutableList()), service.exampleHeaders(), DocService.docString(service.name(), service.docString(), docStrings));
    }

    private static MethodInfo addMethodDocStrings(ServiceInfo service, MethodInfo method, Map<String, String> docStrings) {
        return new MethodInfo(method.name(), method.returnTypeSignature(), method.parameters().stream().map(field -> DocService.addParameterDocString(service, method, field, docStrings)).collect(ImmutableList.toImmutableList()), method.exceptionTypeSignatures(), method.endpoints(), method.exampleHeaders(), method.exampleRequests(), method.examplePaths(), method.exampleQueries(), method.httpMethod(), DocService.docString(service.name() + '/' + method.name(), method.docString(), docStrings));
    }

    private static FieldInfo addParameterDocString(ServiceInfo service, MethodInfo method, FieldInfo field, Map<String, String> docStrings) {
        return new FieldInfo(field.name(), field.location(), field.requirement(), field.typeSignature(), field.childFieldInfos(), DocService.docString(service.name() + '/' + method.name() + '/' + field.name(), field.docString(), docStrings));
    }

    private static EnumInfo addEnumDocStrings(EnumInfo e, Map<String, String> docStrings) {
        return new EnumInfo(e.name(), e.values().stream().map(v -> DocService.addEnumValueDocString(e, v, docStrings)).collect(ImmutableList.toImmutableList()), DocService.docString(e.name(), e.docString(), docStrings));
    }

    private static EnumValueInfo addEnumValueDocString(EnumInfo e, EnumValueInfo v, Map<String, String> docStrings) {
        return new EnumValueInfo(v.name(), v.intValue(), DocService.docString(e.name() + '/' + v.name(), v.docString(), docStrings));
    }

    private static StructInfo addStructDocStrings(StructInfo struct, Map<String, String> docStrings) {
        return new StructInfo(struct.name(), struct.fields().stream().map(field -> DocService.addFieldDocString(struct, field, docStrings)).collect(ImmutableList.toImmutableList()), DocService.docString(struct.name(), struct.docString(), docStrings));
    }

    private static ExceptionInfo addExceptionDocStrings(ExceptionInfo e, Map<String, String> docStrings) {
        return new ExceptionInfo(e.name(), e.fields().stream().map(field -> DocService.addFieldDocString(e, field, docStrings)).collect(ImmutableList.toImmutableList()), DocService.docString(e.name(), e.docString(), docStrings));
    }

    private static FieldInfo addFieldDocString(NamedTypeInfo parent, FieldInfo field, Map<String, String> docStrings) {
        return new FieldInfo(field.name(), field.location(), field.requirement(), field.typeSignature(), field.childFieldInfos(), DocService.docString(parent.name() + '/' + field.name(), field.docString(), docStrings));
    }

    @Nullable
    private static String docString(String key, @Nullable String currentDocString, Map<String, String> docStrings) {
        return currentDocString != null ? currentDocString : docStrings.get(key);
    }

    private ServiceSpecification addExamples(ServiceSpecification spec) {
        return new ServiceSpecification(spec.services().stream().map(this::addServiceExamples).collect(ImmutableList.toImmutableList()), spec.enums(), spec.structs(), spec.exceptions(), Iterables.concat(spec.exampleHeaders(), ((ListMultimap)this.exampleHeaders.getOrDefault("", ImmutableListMultimap.of())).get("")));
    }

    private ServiceInfo addServiceExamples(ServiceInfo service) {
        ListMultimap exampleHeaders = this.exampleHeaders.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap exampleRequests = this.exampleRequests.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap examplePaths = this.examplePaths.getOrDefault(service.name(), ImmutableListMultimap.of());
        ListMultimap exampleQueries = this.exampleQueries.getOrDefault(service.name(), ImmutableListMultimap.of());
        return new ServiceInfo(service.name(), service.methods().stream().map(m -> new MethodInfo(m.name(), m.returnTypeSignature(), m.parameters(), m.exceptionTypeSignatures(), m.endpoints(), DocService.concatAndDedup(exampleHeaders.get(m.name()), m.exampleHeaders()), DocService.concatAndDedup(exampleRequests.get(m.name()), m.exampleRequests()), DocService.concatAndDedup(examplePaths.get(m.name()), m.examplePaths()), DocService.concatAndDedup(exampleQueries.get(m.name()), m.exampleQueries()), m.httpMethod(), m.docString()))::iterator, Iterables.concat(service.exampleHeaders(), exampleHeaders.get("")), service.docString());
    }

    private static <T> Iterable<T> concatAndDedup(Iterable<T> first, Iterable<T> second) {
        return Stream.concat(Streams.stream(first), Streams.stream(second)).distinct().collect(ImmutableList.toImmutableList());
    }

    private DocServiceVfs vfs() {
        return (DocServiceVfs)((FileService)this.unwrap()).config().vfs();
    }

    private static Set<ServiceConfig> findSupportedServices(DocServicePlugin plugin, List<ServiceConfig> services) {
        Set<Class<? extends Service<?, ?>>> supportedServiceTypes = plugin.supportedServiceTypes();
        return services.stream().filter(serviceCfg -> DocService.isSupported(serviceCfg, supportedServiceTypes)).collect(ImmutableSet.toImmutableSet());
    }

    private static boolean isSupported(ServiceConfig serviceCfg, Set<Class<? extends Service<?, ?>>> supportedServiceTypes) {
        return supportedServiceTypes.stream().anyMatch(type -> serviceCfg.service().as(type) != null);
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if ("/injected.js".equals(ctx.mappedPath())) {
            return HttpResponse.of(MediaType.JAVASCRIPT_UTF_8, this.injectedScriptSuppliers.stream().map(f -> (String)f.apply(ctx, req)).collect(Collectors.joining("\n")));
        }
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
    }

    static {
        logger.debug("Available {}s: {}", (Object)DocServicePlugin.class.getSimpleName(), plugins);
    }

    static final class DocServiceVfs
    extends AbstractHttpVfs {
        private final HttpVfs staticFiles = HttpVfs.of(DocService.class.getClassLoader(), "com/linecorp/armeria/server/docs");
        private final Map<String, AggregatedHttpFile> files = new ConcurrentHashMap<String, AggregatedHttpFile>();

        DocServiceVfs() {
        }

        @Override
        @Deprecated
        public HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders) {
            return this.get(fileReadExecutor, path, clock, contentEncoding, additionalHeaders, MediaTypeResolver.ofDefault());
        }

        @Override
        public HttpFile get(Executor fileReadExecutor, String path, Clock clock, @Nullable String contentEncoding, HttpHeaders additionalHeaders, MediaTypeResolver mediaTypeResolver) {
            AggregatedHttpFile file = this.files.get(path);
            if (file != null) {
                assert (file != AggregatedHttpFile.nonExistent());
                HttpFileBuilder builder = HttpFile.builder(file.content(), file.attributes().lastModifiedMillis());
                builder.autoDetectedContentType(false);
                builder.clock(clock);
                builder.setHeaders((Iterable)file.headers());
                builder.setHeaders((Iterable)additionalHeaders);
                if (contentEncoding != null) {
                    builder.setHeader((CharSequence)HttpHeaderNames.CONTENT_ENCODING, contentEncoding);
                }
                return builder.build();
            }
            HttpHeadersBuilder headers = additionalHeaders.toBuilder();
            headers.set((CharSequence)HttpHeaderNames.CACHE_CONTROL, ServerCacheControl.REVALIDATED.asHeaderValue());
            return this.staticFiles.get(fileReadExecutor, path, clock, contentEncoding, headers.build(), MediaTypeResolver.ofDefault());
        }

        @Override
        public String meterTag() {
            return DocService.class.getSimpleName();
        }

        void put(String path, byte[] content) {
            this.put(path, content, MediaType.JSON_UTF_8);
        }

        private void put(String path, byte[] content, MediaType mediaType) {
            this.files.put(path, AggregatedHttpFile.builder(HttpData.wrap(content)).contentType(mediaType).cacheControl(ServerCacheControl.REVALIDATED).build());
        }
    }
}

