/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.annotation;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.ResponseConversionUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class ByteArrayResponseConverterFunction
implements ResponseConverterFunction {
    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        MediaType contentType = headers.contentType();
        if (contentType != null) {
            if (contentType.is(MediaType.APPLICATION_BINARY) || contentType.is(MediaType.OCTET_STREAM)) {
                if (result instanceof Publisher) {
                    return ResponseConversionUtil.streamingFrom((Publisher)result, headers, trailers, ByteArrayResponseConverterFunction::toHttpData);
                }
                if (result instanceof Stream) {
                    return ResponseConversionUtil.streamingFrom((Stream)result, headers, trailers, ByteArrayResponseConverterFunction::toHttpData, ctx.blockingTaskExecutor());
                }
            }
            if (result instanceof HttpData) {
                return HttpResponse.of(headers, (HttpData)result, trailers);
            }
            if (result instanceof byte[]) {
                return HttpResponse.of(headers, HttpData.wrap((byte[])result), trailers);
            }
            return (HttpResponse)ResponseConverterFunction.fallthrough();
        }
        if (result instanceof HttpData) {
            return HttpResponse.of(headers.toBuilder().contentType(MediaType.OCTET_STREAM).build(), (HttpData)result, trailers);
        }
        if (result instanceof byte[]) {
            return HttpResponse.of(headers.toBuilder().contentType(MediaType.OCTET_STREAM).build(), HttpData.wrap((byte[])result), trailers);
        }
        return (HttpResponse)ResponseConverterFunction.fallthrough();
    }

    private static HttpData toHttpData(@Nullable Object value) {
        if (value instanceof HttpData) {
            return (HttpData)value;
        }
        if (value instanceof byte[]) {
            return HttpData.wrap((byte[])value);
        }
        if (value == null) {
            return HttpData.empty();
        }
        throw new IllegalStateException("Failed to convert an object to an HttpData: " + value.getClass().getName());
    }
}

