/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceElement;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceFactory;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.DefaultServiceConfigSetters;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.VirtualHostBuilder;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class VirtualHostAnnotatedServiceBindingBuilder
implements ServiceConfigSetters {
    private final DefaultServiceConfigSetters defaultServiceConfigSetters = new DefaultServiceConfigSetters();
    private final VirtualHostBuilder virtualHostBuilder;
    private final ImmutableList.Builder<ExceptionHandlerFunction> exceptionHandlerFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<RequestConverterFunction> requestConverterFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<ResponseConverterFunction> responseConverterFunctionBuilder = ImmutableList.builder();
    @Nullable
    private String queryDelimiter;
    private boolean useBlockingTaskExecutor;
    private String pathPrefix = "/";
    @Nullable
    private Object service;

    VirtualHostAnnotatedServiceBindingBuilder(VirtualHostBuilder virtualHostBuilder) {
        this.virtualHostBuilder = virtualHostBuilder;
    }

    public VirtualHostAnnotatedServiceBindingBuilder pathPrefix(String pathPrefix) {
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix");
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder exceptionHandlers(ExceptionHandlerFunction ... exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.add(exceptionHandlerFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder exceptionHandlers(Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.addAll(exceptionHandlerFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder responseConverters(ResponseConverterFunction ... responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.add(responseConverterFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder responseConverters(Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.addAll(responseConverterFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder requestConverters(RequestConverterFunction ... requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.add(requestConverterFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder requestConverters(Iterable<? extends RequestConverterFunction> requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.addAll(requestConverterFunctions);
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public VirtualHostAnnotatedServiceBindingBuilder queryDelimiter(String delimiter) {
        this.queryDelimiter = Objects.requireNonNull(delimiter, "delimiter");
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestTimeout(Duration requestTimeout) {
        this.defaultServiceConfigSetters.requestTimeout(requestTimeout);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.defaultServiceConfigSetters.requestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder maxRequestLength(long maxRequestLength) {
        this.defaultServiceConfigSetters.maxRequestLength(maxRequestLength);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder verboseResponses(boolean verboseResponses) {
        this.defaultServiceConfigSetters.verboseResponses(verboseResponses);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder accessLogFormat(String accessLogFormat) {
        this.defaultServiceConfigSetters.accessLogFormat(accessLogFormat);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.accessLogWriter(accessLogWriter, shutdownOnStop);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.defaultServiceConfigSetters.decorator(decorator);
        return this;
    }

    @Override
    @SafeVarargs
    public final VirtualHostAnnotatedServiceBindingBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder defaultServiceName(String defaultServiceName) {
        this.defaultServiceConfigSetters.defaultServiceName(defaultServiceName);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceConfigSetters.defaultServiceNaming(defaultServiceNaming);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder defaultLogName(String defaultLogName) {
        this.defaultServiceConfigSetters.defaultLogName(defaultLogName);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder blockingTaskExecutor(int numThreads) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(numThreads);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder successFunction(SuccessFunction successFunction) {
        this.defaultServiceConfigSetters.successFunction(successFunction);
        return this;
    }

    @Override
    public VirtualHostAnnotatedServiceBindingBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.defaultServiceConfigSetters.multipartUploadsLocation(multipartUploadsLocation);
        return this;
    }

    public VirtualHostBuilder build(Object service) {
        Objects.requireNonNull(service, "service");
        this.service = service;
        this.virtualHostBuilder.addServiceConfigSetters(this);
        return this.virtualHostBuilder;
    }

    List<ServiceConfigBuilder> buildServiceConfigBuilder(AnnotatedServiceExtensions extensions) {
        ImmutableCollection requestConverterFunctions = ((ImmutableList.Builder)this.requestConverterFunctionBuilder.addAll(extensions.requestConverters())).build();
        ImmutableCollection responseConverterFunctions = ((ImmutableList.Builder)this.responseConverterFunctionBuilder.addAll(extensions.responseConverters())).build();
        ImmutableCollection exceptionHandlerFunctions = ((ImmutableList.Builder)this.exceptionHandlerFunctionBuilder.addAll(extensions.exceptionHandlers())).build();
        assert (this.service != null);
        List<AnnotatedServiceElement> elements = AnnotatedServiceFactory.find(this.pathPrefix, this.service, this.useBlockingTaskExecutor, this.queryDelimiter, (List<RequestConverterFunction>)((Object)requestConverterFunctions), (List<ResponseConverterFunction>)((Object)responseConverterFunctions), (List<ExceptionHandlerFunction>)((Object)exceptionHandlerFunctions));
        return elements.stream().map(element -> {
            HttpService decoratedService = element.buildSafeDecoratedService(this.defaultServiceConfigSetters.decorator());
            return this.defaultServiceConfigSetters.toServiceConfigBuilder(element.route(), decoratedService);
        }).collect(ImmutableList.toImmutableList());
    }
}

