/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.server.DomainMappingBuilder;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RejectedRouteHandler;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.Routers;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Mapping;
import java.net.IDN;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class VirtualHost {
    static final Pattern HOSTNAME_WITH_NO_PORT_PATTERN = Pattern.compile("^(?:[-_a-zA-Z0-9]|[-_a-zA-Z0-9][-_.a-zA-Z0-9]*[-_a-zA-Z0-9])$");
    @Nullable
    private ServerConfig serverConfig;
    private final String originalDefaultHostname;
    private final String originalHostnamePattern;
    private final String defaultHostname;
    private final String hostnamePattern;
    private final int port;
    @Nullable
    private final SslContext sslContext;
    private final Router<ServiceConfig> router;
    private final List<ServiceConfig> serviceConfigs;
    private final ServiceConfig fallbackServiceConfig;
    private final Logger accessLogger;
    private final ServiceNaming defaultServiceNaming;
    private final long requestTimeoutMillis;
    private final long maxRequestLength;
    private final boolean verboseResponses;
    private final AccessLogWriter accessLogWriter;
    private final boolean shutdownAccessLogWriterOnStop;
    private final ScheduledExecutorService blockingTaskExecutor;
    private final boolean shutdownBlockingTaskExecutorOnStop;

    VirtualHost(String defaultHostname, String hostnamePattern, int port, @Nullable SslContext sslContext, Iterable<ServiceConfig> serviceConfigs, ServiceConfig fallbackServiceConfig, RejectedRouteHandler rejectionHandler, Function<? super VirtualHost, ? extends Logger> accessLoggerMapper, @Nullable ServiceNaming defaultServiceNaming, long requestTimeoutMillis, long maxRequestLength, boolean verboseResponses, AccessLogWriter accessLogWriter, boolean shutdownAccessLogWriterOnStop, ScheduledExecutorService blockingTaskExecutor, boolean shutdownBlockingTaskExecutorOnStop) {
        this.originalDefaultHostname = defaultHostname;
        this.originalHostnamePattern = hostnamePattern;
        if (port > 0) {
            this.defaultHostname = defaultHostname + ':' + port;
            this.hostnamePattern = hostnamePattern + ':' + port;
        } else {
            this.defaultHostname = defaultHostname;
            this.hostnamePattern = hostnamePattern;
        }
        this.port = port;
        this.sslContext = sslContext;
        this.defaultServiceNaming = defaultServiceNaming;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.maxRequestLength = maxRequestLength;
        this.verboseResponses = verboseResponses;
        this.accessLogWriter = accessLogWriter;
        this.shutdownAccessLogWriterOnStop = shutdownAccessLogWriterOnStop;
        this.blockingTaskExecutor = blockingTaskExecutor;
        this.shutdownBlockingTaskExecutorOnStop = shutdownBlockingTaskExecutorOnStop;
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(fallbackServiceConfig, "fallbackServiceConfig");
        this.serviceConfigs = Streams.stream(serviceConfigs).map(sc -> sc.withVirtualHost(this)).collect(ImmutableList.toImmutableList());
        this.fallbackServiceConfig = fallbackServiceConfig.withVirtualHost(this);
        this.router = Routers.ofVirtualHost(this, this.serviceConfigs, rejectionHandler);
        this.accessLogger = accessLoggerMapper.apply(this);
        Preconditions.checkState(this.accessLogger != null, "accessLoggerMapper.apply() has returned null for virtual host: %s.", hostnamePattern);
    }

    VirtualHost withNewSslContext(SslContext sslContext) {
        return new VirtualHost(this.originalDefaultHostname, this.originalHostnamePattern, this.port, sslContext, this.serviceConfigs(), this.fallbackServiceConfig, RejectedRouteHandler.DISABLED, host -> this.accessLogger, this.defaultServiceNaming(), this.requestTimeoutMillis(), this.maxRequestLength(), this.verboseResponses(), this.accessLogWriter(), this.shutdownAccessLogWriterOnStop(), this.blockingTaskExecutor(), this.shutdownBlockingTaskExecutorOnStop());
    }

    static String normalizeDefaultHostname(String defaultHostname) {
        Objects.requireNonNull(defaultHostname, "defaultHostname");
        if (VirtualHost.needsNormalization(defaultHostname)) {
            defaultHostname = IDN.toASCII(defaultHostname, 1);
        }
        if (!HOSTNAME_WITH_NO_PORT_PATTERN.matcher(defaultHostname).matches()) {
            throw new IllegalArgumentException("defaultHostname: " + defaultHostname);
        }
        return Ascii.toLowerCase(defaultHostname);
    }

    static String normalizeHostnamePattern(String hostnamePattern) {
        String withoutWildCard;
        Objects.requireNonNull(hostnamePattern, "hostnamePattern");
        if (VirtualHost.needsNormalization(hostnamePattern)) {
            hostnamePattern = IDN.toASCII(hostnamePattern, 1);
        }
        String string = withoutWildCard = hostnamePattern.startsWith("*.") ? hostnamePattern.substring(2) : hostnamePattern;
        if (!"*".equals(hostnamePattern) && !HOSTNAME_WITH_NO_PORT_PATTERN.matcher(withoutWildCard).matches()) {
            throw new IllegalArgumentException("hostnamePattern: " + hostnamePattern);
        }
        return Ascii.toLowerCase(hostnamePattern);
    }

    static void ensureHostnamePatternMatchesDefaultHostname(String hostnamePattern, String defaultHostname) {
        if ("*".equals(hostnamePattern)) {
            return;
        }
        Mapping mapping = new DomainMappingBuilder<Boolean>(Boolean.FALSE).add(hostnamePattern, Boolean.TRUE).build();
        if (!((Boolean)mapping.map((Object)defaultHostname)).booleanValue()) {
            throw new IllegalArgumentException("defaultHostname: " + defaultHostname + " (must be matched by hostnamePattern: " + hostnamePattern + ')');
        }
    }

    private static boolean needsNormalization(String hostnamePattern) {
        int length = hostnamePattern.length();
        for (int i = 0; i < length; ++i) {
            char c = hostnamePattern.charAt(i);
            if (c <= '\u007f') continue;
            return true;
        }
        return false;
    }

    String originalHostnamePattern() {
        return this.originalHostnamePattern;
    }

    public Server server() {
        if (this.serverConfig == null) {
            throw new IllegalStateException("server is not configured yet.");
        }
        return this.serverConfig.server();
    }

    void setServerConfig(ServerConfig serverConfig) {
        if (this.serverConfig != null) {
            throw new IllegalStateException("VirtualHost cannot be added to more than one Server.");
        }
        this.serverConfig = Objects.requireNonNull(serverConfig, "serverConfig");
        MeterRegistry registry = serverConfig.meterRegistry();
        MeterIdPrefix idPrefix = new MeterIdPrefix("armeria.server.router.virtual.host.cache", "hostname.pattern", this.hostnamePattern);
        this.router.registerMetrics(registry, idPrefix);
    }

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String hostnamePattern() {
        return this.hostnamePattern;
    }

    public int port() {
        return this.port;
    }

    @Nullable
    public SslContext sslContext() {
        return this.sslContext;
    }

    public List<ServiceConfig> serviceConfigs() {
        return this.serviceConfigs;
    }

    public Logger accessLogger() {
        return this.accessLogger;
    }

    public ServiceNaming defaultServiceNaming() {
        return this.defaultServiceNaming;
    }

    public long requestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public long maxRequestLength() {
        return this.maxRequestLength;
    }

    public boolean verboseResponses() {
        return this.verboseResponses;
    }

    public AccessLogWriter accessLogWriter() {
        return this.accessLogWriter;
    }

    public boolean shutdownAccessLogWriterOnStop() {
        return this.shutdownAccessLogWriterOnStop;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public boolean shutdownBlockingTaskExecutorOnStop() {
        return this.shutdownBlockingTaskExecutorOnStop;
    }

    public Routed<ServiceConfig> findServiceConfig(RoutingContext routingCtx) {
        return this.findServiceConfig(routingCtx, false);
    }

    public Routed<ServiceConfig> findServiceConfig(RoutingContext routingCtx, boolean useFallbackService) {
        Routed<ServiceConfig> routed = this.router.find(Objects.requireNonNull(routingCtx, "routingCtx"));
        switch (routed.routingResultType()) {
            case MATCHED: {
                return routed;
            }
            case NOT_MATCHED: {
                if (useFallbackService) break;
                return routed;
            }
            case CORS_PREFLIGHT: {
                assert (routingCtx.status() == RoutingStatus.CORS_PREFLIGHT);
                if (!routed.value().handlesCorsPreflight()) break;
                return routed;
            }
            default: {
                throw new Error();
            }
        }
        return Routed.of(this.fallbackServiceConfig.route(), RoutingResult.builder().path(routingCtx.path()).query(routingCtx.query()).build(), this.fallbackServiceConfig);
    }

    ServiceConfig fallbackServiceConfig() {
        return this.fallbackServiceConfig;
    }

    VirtualHost decorate(@Nullable Function<? super HttpService, ? extends HttpService> decorator) {
        if (decorator == null) {
            return this;
        }
        List<ServiceConfig> serviceConfigs = this.serviceConfigs.stream().map(cfg -> cfg.withDecoratedService(decorator)).collect(Collectors.toList());
        ServiceConfig fallbackServiceConfig = this.fallbackServiceConfig.withDecoratedService(decorator);
        return new VirtualHost(this.originalDefaultHostname, this.originalHostnamePattern, this.port, this.sslContext(), serviceConfigs, fallbackServiceConfig, RejectedRouteHandler.DISABLED, host -> this.accessLogger, this.defaultServiceNaming(), this.requestTimeoutMillis(), this.maxRequestLength(), this.verboseResponses(), this.accessLogWriter(), this.shutdownAccessLogWriterOnStop(), this.blockingTaskExecutor(), this.shutdownBlockingTaskExecutorOnStop());
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean withTypeName) {
        StringBuilder buf = new StringBuilder();
        if (withTypeName) {
            buf.append(this.getClass().getSimpleName());
        }
        buf.append('(');
        buf.append(this.defaultHostname());
        buf.append('/');
        buf.append(this.hostnamePattern());
        buf.append(", ssl: ");
        buf.append(this.sslContext() != null);
        buf.append(", services: ");
        buf.append(this.serviceConfigs);
        buf.append(", accessLogger: ");
        buf.append(this.accessLogger());
        buf.append(", defaultServiceNaming: ");
        buf.append(this.defaultServiceNaming());
        buf.append(", requestTimeoutMillis: ");
        buf.append(this.requestTimeoutMillis());
        buf.append(", maxRequestLength: ");
        buf.append(this.maxRequestLength());
        buf.append(", verboseResponses: ");
        buf.append(this.verboseResponses());
        buf.append(", accessLogWriter: ");
        buf.append(this.accessLogWriter());
        buf.append(", shutdownAccessLogWriterOnStop: ");
        buf.append(this.shutdownAccessLogWriterOnStop());
        buf.append(", blockingTaskExecutor: ");
        buf.append(this.blockingTaskExecutor());
        buf.append(", shutdownBlockingTaskExecutorOnStop: ");
        buf.append(this.shutdownBlockingTaskExecutorOnStop());
        buf.append(')');
        return buf.toString();
    }

    String toStringWithoutTypeName() {
        return this.toString(false);
    }
}

