/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.PathAndQuery;
import com.linecorp.armeria.server.DefaultRoutingContext;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.VirtualHost;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;

final class ServiceRouteUtil {
    static RoutingContext newRoutingContext(ServerConfig serverConfig, Channel channel, RequestHeaders headers) {
        String hostname = ServiceRouteUtil.hostname(headers);
        int port = ((InetSocketAddress)channel.localAddress()).getPort();
        String originalPath = headers.path();
        PathAndQuery pathAndQuery = null;
        RoutingStatus routingStatus = originalPath.isEmpty() || originalPath.charAt(0) != '/' ? (headers.method() == HttpMethod.OPTIONS && "*".equals(originalPath) ? RoutingStatus.OPTIONS : RoutingStatus.INVALID_PATH) : (ArmeriaHttpUtil.isCorsPreflightRequest(headers) ? RoutingStatus.CORS_PREFLIGHT : ((pathAndQuery = PathAndQuery.parse(originalPath)) != null ? RoutingStatus.OK : RoutingStatus.INVALID_PATH));
        VirtualHost virtualHost = serverConfig.findVirtualHost(hostname, port);
        if (routingStatus != RoutingStatus.OK) {
            return DefaultRoutingContext.of(virtualHost, hostname, headers.path(), null, headers, routingStatus);
        }
        return DefaultRoutingContext.of(virtualHost, hostname, pathAndQuery, headers, routingStatus);
    }

    private static String hostname(RequestHeaders headers) {
        String authority = headers.authority();
        assert (authority != null);
        int hostnameColonIdx = authority.lastIndexOf(58);
        if (hostnameColonIdx < 0) {
            return authority;
        }
        return authority.substring(0, hostnameColonIdx);
    }

    private ServiceRouteUtil() {
    }
}

