/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

final class ServiceConfigBuilder
implements ServiceConfigSetters {
    private final Route route;
    private final HttpService service;
    @Nullable
    private Route mappedRoute;
    @Nullable
    private String defaultServiceName;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private ScheduledExecutorService blockingTaskExecutor;
    @Nullable
    private SuccessFunction successFunction;
    private boolean shutdownBlockingTaskExecutorOnStop;
    private boolean shutdownAccessLogWriterOnStop;
    @Nullable
    private Path multipartUploadsLocation;

    ServiceConfigBuilder(Route route, HttpService service) {
        this.route = Objects.requireNonNull(route, "route");
        this.service = Objects.requireNonNull(service, "service");
    }

    void addMappedRoute(Route mappedRoute) {
        this.mappedRoute = Objects.requireNonNull(mappedRoute, "mappedRoute");
    }

    @Override
    public ServiceConfigBuilder requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(requestTimeout.toMillis());
    }

    @Override
    public ServiceConfigBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    @Override
    public ServiceConfigBuilder maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = maxRequestLength;
        return this;
    }

    @Override
    public ServiceConfigBuilder verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    @Override
    public ServiceConfigBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.accessLogWriter = accessLogWriter;
        this.shutdownAccessLogWriterOnStop = shutdownOnStop;
        return this;
    }

    @Override
    public ServiceConfigBuilder accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), true);
    }

    @Override
    public ServiceConfigBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @SafeVarargs
    public final ServiceConfigBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceConfigBuilder defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.shutdownBlockingTaskExecutorOnStop = shutdownOnStop;
        return this;
    }

    @Override
    public ServiceConfigBuilder blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @Override
    public ServiceConfigBuilder successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    @Override
    public ServiceConfigBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = multipartUploadsLocation;
        return this;
    }

    @Override
    public ServiceConfigBuilder defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = ServiceNaming.of(defaultServiceName);
        return this;
    }

    @Override
    public ServiceConfigBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceName = null;
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    ServiceConfig build(ServiceNaming defaultServiceNaming, long defaultRequestTimeoutMillis, long defaultMaxRequestLength, boolean defaultVerboseResponses, AccessLogWriter defaultAccessLogWriter, boolean defaultShutdownAccessLogWriterOnStop, ScheduledExecutorService defaultBlockingTaskExecutor, boolean defaultShutdownBlockingTaskExecutorOnStop, SuccessFunction defaultSuccessFunction, Path defaultMultipartUploadsLocation) {
        return new ServiceConfig(this.route, this.mappedRoute == null ? this.route : this.mappedRoute, this.service, this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming != null ? this.defaultServiceNaming : defaultServiceNaming, this.requestTimeoutMillis != null ? this.requestTimeoutMillis : defaultRequestTimeoutMillis, this.maxRequestLength != null ? this.maxRequestLength : defaultMaxRequestLength, this.verboseResponses != null ? this.verboseResponses : defaultVerboseResponses, this.accessLogWriter != null ? this.accessLogWriter : defaultAccessLogWriter, this.accessLogWriter != null ? this.shutdownAccessLogWriterOnStop : defaultShutdownAccessLogWriterOnStop, this.blockingTaskExecutor != null ? this.blockingTaskExecutor : defaultBlockingTaskExecutor, this.blockingTaskExecutor != null ? this.shutdownBlockingTaskExecutorOnStop : defaultShutdownBlockingTaskExecutorOnStop, this.successFunction != null ? this.successFunction : defaultSuccessFunction, this.multipartUploadsLocation != null ? this.multipartUploadsLocation : defaultMultipartUploadsLocation);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("route", this.route).add("service", this.service).add("defaultServiceNaming", this.defaultServiceNaming).add("requestTimeoutMillis", this.requestTimeoutMillis).add("maxRequestLength", this.maxRequestLength).add("verboseResponses", this.verboseResponses).add("accessLogWriter", this.accessLogWriter).add("shutdownAccessLogWriterOnStop", this.shutdownAccessLogWriterOnStop).add("blockingTaskExecutor", this.blockingTaskExecutor).add("shutdownBlockingTaskExecutorOnStop", this.shutdownBlockingTaskExecutorOnStop).add("successFunction", this.successFunction).add("multipartUploadsLocation", this.multipartUploadsLocation).toString();
    }
}

