/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.TransientService;
import com.linecorp.armeria.server.TransientServiceOption;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.cors.CorsService;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class ServiceConfig {
    @Nullable
    private final VirtualHost virtualHost;
    private final Route route;
    private final Route mappedRoute;
    private final HttpService service;
    @Nullable
    private final String defaultServiceName;
    private final ServiceNaming defaultServiceNaming;
    @Nullable
    private final String defaultLogName;
    private final long requestTimeoutMillis;
    private final long maxRequestLength;
    private final boolean verboseResponses;
    private final AccessLogWriter accessLogWriter;
    private final boolean shutdownAccessLogWriterOnStop;
    private final Set<TransientServiceOption> transientServiceOptions;
    private final boolean handlesCorsPreflight;
    private final SuccessFunction successFunction;
    private final ScheduledExecutorService blockingTaskExecutor;
    private final boolean shutdownBlockingTaskExecutorOnStop;
    private final Path multipartUploadsLocation;

    ServiceConfig(Route route, Route mappedRoute, HttpService service, @Nullable String defaultLogName, @Nullable String defaultServiceName, ServiceNaming defaultServiceNaming, long requestTimeoutMillis, long maxRequestLength, boolean verboseResponses, AccessLogWriter accessLogWriter, boolean shutdownAccessLogWriterOnStop, ScheduledExecutorService blockingTaskExecutor, boolean shutdownBlockingTaskExecutorOnStop, SuccessFunction successFunction, Path multipartUploadsLocation) {
        this(null, route, mappedRoute, service, defaultLogName, defaultServiceName, defaultServiceNaming, requestTimeoutMillis, maxRequestLength, verboseResponses, accessLogWriter, shutdownAccessLogWriterOnStop, ServiceConfig.extractTransientServiceOptions(service), blockingTaskExecutor, shutdownBlockingTaskExecutorOnStop, successFunction, multipartUploadsLocation);
    }

    private ServiceConfig(@Nullable VirtualHost virtualHost, Route route, Route mappedRoute, HttpService service, @Nullable String defaultLogName, @Nullable String defaultServiceName, ServiceNaming defaultServiceNaming, long requestTimeoutMillis, long maxRequestLength, boolean verboseResponses, AccessLogWriter accessLogWriter, boolean shutdownAccessLogWriterOnStop, Set<TransientServiceOption> transientServiceOptions, ScheduledExecutorService blockingTaskExecutor, boolean shutdownBlockingTaskExecutorOnStop, SuccessFunction successFunction, Path multipartUploadsLocation) {
        this.virtualHost = virtualHost;
        this.route = Objects.requireNonNull(route, "route");
        this.mappedRoute = Objects.requireNonNull(mappedRoute, "mappedRoute");
        this.service = Objects.requireNonNull(service, "service");
        this.defaultLogName = defaultLogName;
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = defaultServiceNaming;
        this.requestTimeoutMillis = ServiceConfig.validateRequestTimeoutMillis(requestTimeoutMillis);
        this.maxRequestLength = ServiceConfig.validateMaxRequestLength(maxRequestLength);
        this.verboseResponses = verboseResponses;
        this.accessLogWriter = Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.shutdownAccessLogWriterOnStop = shutdownAccessLogWriterOnStop;
        this.transientServiceOptions = Objects.requireNonNull(transientServiceOptions, "transientServiceOptions");
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.shutdownBlockingTaskExecutorOnStop = shutdownBlockingTaskExecutorOnStop;
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        this.multipartUploadsLocation = multipartUploadsLocation;
        this.handlesCorsPreflight = service.as(CorsService.class) != null;
    }

    private static Set<TransientServiceOption> extractTransientServiceOptions(HttpService service) {
        TransientService transientService = service.as(TransientService.class);
        if (transientService == null) {
            return TransientServiceOption.allOf();
        }
        Set<TransientServiceOption> transientServiceOptions = transientService.transientServiceOptions();
        return transientServiceOptions;
    }

    static long validateRequestTimeoutMillis(long requestTimeoutMillis) {
        if (requestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("requestTimeoutMillis: " + requestTimeoutMillis + " (expected: >= 0)");
        }
        return requestTimeoutMillis;
    }

    static long validateMaxRequestLength(long maxRequestLength) {
        if (maxRequestLength < 0L) {
            throw new IllegalArgumentException("maxRequestLength: " + maxRequestLength + " (expected: >= 0)");
        }
        return maxRequestLength;
    }

    ServiceConfig withVirtualHost(VirtualHost virtualHost) {
        Objects.requireNonNull(virtualHost, "virtualHost");
        return new ServiceConfig(virtualHost, this.route, this.mappedRoute, this.service, this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.shutdownAccessLogWriterOnStop, this.transientServiceOptions, this.blockingTaskExecutor, this.shutdownBlockingTaskExecutorOnStop, this.successFunction, this.multipartUploadsLocation);
    }

    ServiceConfig withDecoratedService(Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(decorator, "decorator");
        return new ServiceConfig(this.virtualHost, this.route, this.mappedRoute, this.service.decorate(decorator), this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.shutdownAccessLogWriterOnStop, this.transientServiceOptions, this.blockingTaskExecutor, this.shutdownBlockingTaskExecutorOnStop, this.successFunction, this.multipartUploadsLocation);
    }

    ServiceConfig withRoute(Route route) {
        Objects.requireNonNull(route, "route");
        return new ServiceConfig(this.virtualHost, route, this.mappedRoute, this.service, this.defaultLogName, this.defaultServiceName, this.defaultServiceNaming, this.requestTimeoutMillis, this.maxRequestLength, this.verboseResponses, this.accessLogWriter, this.shutdownAccessLogWriterOnStop, this.transientServiceOptions, this.blockingTaskExecutor, this.shutdownBlockingTaskExecutorOnStop, this.successFunction, this.multipartUploadsLocation);
    }

    public VirtualHost virtualHost() {
        if (this.virtualHost == null) {
            throw new IllegalStateException("Server has not been configured yet.");
        }
        return this.virtualHost;
    }

    public Server server() {
        return this.virtualHost().server();
    }

    public Route route() {
        return this.route;
    }

    public Route mappedRoute() {
        return this.mappedRoute;
    }

    public HttpService service() {
        return this.service;
    }

    @Nullable
    @Deprecated
    public String defaultServiceName() {
        return this.defaultServiceName;
    }

    public ServiceNaming defaultServiceNaming() {
        return this.defaultServiceNaming;
    }

    @Nullable
    public String defaultLogName() {
        return this.defaultLogName;
    }

    public long requestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public long maxRequestLength() {
        return this.maxRequestLength;
    }

    public boolean verboseResponses() {
        return this.verboseResponses;
    }

    public AccessLogWriter accessLogWriter() {
        return this.accessLogWriter;
    }

    public boolean shutdownAccessLogWriterOnStop() {
        return this.shutdownAccessLogWriterOnStop;
    }

    public Set<TransientServiceOption> transientServiceOptions() {
        return this.transientServiceOptions;
    }

    boolean handlesCorsPreflight() {
        return this.handlesCorsPreflight;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public boolean shutdownBlockingTaskExecutorOnStop() {
        return this.shutdownBlockingTaskExecutorOnStop;
    }

    public SuccessFunction successFunction() {
        return this.successFunction;
    }

    public Path multipartUploadsLocation() {
        return this.multipartUploadsLocation;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).omitNullValues();
        if (this.virtualHost != null) {
            toStringHelper.add("hostnamePattern", this.virtualHost.hostnamePattern());
        }
        return toStringHelper.add("route", this.route).add("service", this.service).add("defaultServiceNaming", this.defaultServiceNaming).add("defaultLogName", this.defaultLogName).add("requestTimeoutMillis", this.requestTimeoutMillis).add("maxRequestLength", this.maxRequestLength).add("verboseResponses", this.verboseResponses).add("accessLogWriter", this.accessLogWriter).add("shutdownAccessLogWriterOnStop", this.shutdownAccessLogWriterOnStop).add("blockingTaskExecutor", this.blockingTaskExecutor).add("shutdownBlockingTaskExecutorOnStop", this.shutdownBlockingTaskExecutorOnStop).add("successFunction", this.successFunction).add("multipartUploadsLocation", this.multipartUploadsLocation).toString();
    }
}

