/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.AbstractServiceBindingBuilder;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ServiceBindingBuilder
extends AbstractServiceBindingBuilder {
    private final ServerBuilder serverBuilder;
    @Nullable
    private Route mappedRoute;

    ServiceBindingBuilder(ServerBuilder serverBuilder) {
        this.serverBuilder = Objects.requireNonNull(serverBuilder, "serverBuilder");
    }

    @Override
    public ServiceBindingBuilder path(String pathPattern) {
        return (ServiceBindingBuilder)super.path(pathPattern);
    }

    @Override
    public ServiceBindingBuilder pathPrefix(String prefix) {
        return (ServiceBindingBuilder)super.pathPrefix(prefix);
    }

    @Override
    public ServiceBindingBuilder methods(HttpMethod ... methods) {
        return (ServiceBindingBuilder)super.methods(methods);
    }

    @Override
    public ServiceBindingBuilder methods(Iterable<HttpMethod> methods) {
        return (ServiceBindingBuilder)super.methods(methods);
    }

    @Override
    public ServiceBindingBuilder get(String pathPattern) {
        return (ServiceBindingBuilder)super.get(pathPattern);
    }

    @Override
    public ServiceBindingBuilder post(String pathPattern) {
        return (ServiceBindingBuilder)super.post(pathPattern);
    }

    @Override
    public ServiceBindingBuilder put(String pathPattern) {
        return (ServiceBindingBuilder)super.put(pathPattern);
    }

    @Override
    public ServiceBindingBuilder patch(String pathPattern) {
        return (ServiceBindingBuilder)super.patch(pathPattern);
    }

    @Override
    public ServiceBindingBuilder delete(String pathPattern) {
        return (ServiceBindingBuilder)super.delete(pathPattern);
    }

    @Override
    public ServiceBindingBuilder options(String pathPattern) {
        return (ServiceBindingBuilder)super.options(pathPattern);
    }

    @Override
    public ServiceBindingBuilder head(String pathPattern) {
        return (ServiceBindingBuilder)super.head(pathPattern);
    }

    @Override
    public ServiceBindingBuilder trace(String pathPattern) {
        return (ServiceBindingBuilder)super.trace(pathPattern);
    }

    @Override
    public ServiceBindingBuilder connect(String pathPattern) {
        return (ServiceBindingBuilder)super.connect(pathPattern);
    }

    @Override
    public ServiceBindingBuilder consumes(MediaType ... consumeTypes) {
        return (ServiceBindingBuilder)super.consumes(consumeTypes);
    }

    @Override
    public ServiceBindingBuilder consumes(Iterable<MediaType> consumeTypes) {
        return (ServiceBindingBuilder)super.consumes(consumeTypes);
    }

    @Override
    public ServiceBindingBuilder produces(MediaType ... produceTypes) {
        return (ServiceBindingBuilder)super.produces(produceTypes);
    }

    @Override
    public ServiceBindingBuilder produces(Iterable<MediaType> produceTypes) {
        return (ServiceBindingBuilder)super.produces(produceTypes);
    }

    @Override
    public ServiceBindingBuilder matchesParams(String ... paramPredicates) {
        return (ServiceBindingBuilder)super.matchesParams(paramPredicates);
    }

    @Override
    public ServiceBindingBuilder matchesParams(Iterable<String> paramPredicates) {
        return (ServiceBindingBuilder)super.matchesParams(paramPredicates);
    }

    @Override
    public ServiceBindingBuilder matchesParams(String paramName, Predicate<? super String> valuePredicate) {
        return (ServiceBindingBuilder)super.matchesParams(paramName, valuePredicate);
    }

    @Override
    public ServiceBindingBuilder matchesHeaders(String ... headerPredicates) {
        return (ServiceBindingBuilder)super.matchesHeaders(headerPredicates);
    }

    @Override
    public ServiceBindingBuilder matchesHeaders(Iterable<String> headerPredicates) {
        return (ServiceBindingBuilder)super.matchesHeaders(headerPredicates);
    }

    @Override
    public ServiceBindingBuilder matchesHeaders(CharSequence headerName, Predicate<? super String> valuePredicate) {
        return (ServiceBindingBuilder)super.matchesHeaders(headerName, valuePredicate);
    }

    @Override
    public ServiceBindingBuilder addRoute(Route route) {
        return (ServiceBindingBuilder)super.addRoute(route);
    }

    ServiceBindingBuilder mappedRoute(Route mappedRoute) {
        this.mappedRoute = Objects.requireNonNull(mappedRoute, "mappedRoute");
        return this;
    }

    @Override
    public ServiceBindingBuilder exclude(String pathPattern) {
        return (ServiceBindingBuilder)super.exclude(pathPattern);
    }

    @Override
    public ServiceBindingBuilder exclude(Route excludedRoute) {
        return (ServiceBindingBuilder)super.exclude(excludedRoute);
    }

    @Override
    public ServiceBindingBuilder defaultServiceName(String defaultServiceName) {
        return (ServiceBindingBuilder)super.defaultServiceName(defaultServiceName);
    }

    @Override
    public ServiceBindingBuilder defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        return (ServiceBindingBuilder)super.defaultServiceNaming(defaultServiceNaming);
    }

    @Override
    public ServiceBindingBuilder defaultLogName(String defaultLogName) {
        return (ServiceBindingBuilder)super.defaultLogName(defaultLogName);
    }

    @Override
    public ServiceBindingBuilder blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        return (ServiceBindingBuilder)super.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
    }

    @Override
    public ServiceBindingBuilder blockingTaskExecutor(int numThreads) {
        return (ServiceBindingBuilder)super.blockingTaskExecutor(numThreads);
    }

    @Override
    public ServiceBindingBuilder successFunction(SuccessFunction successFunction) {
        return (ServiceBindingBuilder)super.successFunction(successFunction);
    }

    @Override
    public ServiceBindingBuilder requestTimeout(Duration requestTimeout) {
        return (ServiceBindingBuilder)super.requestTimeout(requestTimeout);
    }

    @Override
    public ServiceBindingBuilder requestTimeoutMillis(long requestTimeoutMillis) {
        return (ServiceBindingBuilder)super.requestTimeoutMillis(requestTimeoutMillis);
    }

    @Override
    public ServiceBindingBuilder maxRequestLength(long maxRequestLength) {
        return (ServiceBindingBuilder)super.maxRequestLength(maxRequestLength);
    }

    @Override
    public ServiceBindingBuilder verboseResponses(boolean verboseResponses) {
        return (ServiceBindingBuilder)super.verboseResponses(verboseResponses);
    }

    @Override
    public ServiceBindingBuilder accessLogFormat(String accessLogFormat) {
        return (ServiceBindingBuilder)super.accessLogFormat(accessLogFormat);
    }

    @Override
    public ServiceBindingBuilder accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        return (ServiceBindingBuilder)super.accessLogWriter(accessLogWriter, shutdownOnStop);
    }

    @Override
    public ServiceBindingBuilder multipartUploadsLocation(Path multipartUploadsLocation) {
        return (ServiceBindingBuilder)super.multipartUploadsLocation(multipartUploadsLocation);
    }

    @Override
    public ServiceBindingBuilder decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        return (ServiceBindingBuilder)super.decorator((Function)decorator);
    }

    @Override
    @SafeVarargs
    public final ServiceBindingBuilder decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        return (ServiceBindingBuilder)super.decorators((Function[])decorators);
    }

    @Override
    public ServiceBindingBuilder decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        return (ServiceBindingBuilder)super.decorators((Iterable)decorators);
    }

    public ServerBuilder build(HttpService service) {
        if (this.mappedRoute != null) {
            assert (service.as(HttpServiceWithRoutes.class) != null);
            this.build0(service, this.mappedRoute);
        } else {
            this.build0(service);
        }
        return this.serverBuilder;
    }

    @Override
    void serviceConfigBuilder(ServiceConfigBuilder serviceConfigBuilder) {
        this.serverBuilder.serviceConfigBuilder(serviceConfigBuilder);
    }
}

