/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.common.util.SslContextUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

final class ServerSslContextUtil {
    static SSLSession validateSslContext(SslContext sslContext) {
        SSLSession sslSession;
        if (!sslContext.isServer()) {
            throw new IllegalArgumentException("sslContext: " + sslContext + " (expected: server context)");
        }
        SSLEngine serverEngine = null;
        SSLEngine clientEngine = null;
        try {
            serverEngine = sslContext.newEngine(ByteBufAllocator.DEFAULT);
            serverEngine.setUseClientMode(false);
            serverEngine.setNeedClientAuth(false);
            SslContext sslContextClient = ServerSslContextUtil.buildSslContext(() -> SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE), true, ImmutableList.of());
            clientEngine = sslContextClient.newEngine(ByteBufAllocator.DEFAULT);
            clientEngine.setUseClientMode(true);
            clientEngine.setEnabledProtocols(clientEngine.getSupportedProtocols());
            clientEngine.setEnabledCipherSuites(clientEngine.getSupportedCipherSuites());
            ByteBuffer packetBuf = ByteBuffer.allocate(clientEngine.getSession().getPacketBufferSize());
            ServerSslContextUtil.wrap(clientEngine, packetBuf);
            packetBuf.flip();
            ServerSslContextUtil.unwrap(serverEngine, packetBuf);
            packetBuf.clear();
            ServerSslContextUtil.wrap(serverEngine, packetBuf);
            sslSession = serverEngine.getHandshakeSession();
        }
        catch (SSLException e) {
            try {
                throw new IllegalStateException("failed to validate SSL/TLS configuration: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)serverEngine);
                ReferenceCountUtil.release(clientEngine);
                throw throwable;
            }
        }
        ReferenceCountUtil.release((Object)serverEngine);
        ReferenceCountUtil.release((Object)clientEngine);
        return sslSession;
    }

    static SslContext buildSslContext(Supplier<SslContextBuilder> sslContextBuilderSupplier, boolean tlsAllowUnsafeCiphers, Iterable<? extends Consumer<? super SslContextBuilder>> tlsCustomizers) {
        return SslContextUtil.createSslContext(sslContextBuilderSupplier, false, tlsAllowUnsafeCiphers, tlsCustomizers);
    }

    private static void unwrap(SSLEngine engine, ByteBuffer packetBuf) throws SSLException {
        ByteBuffer appBuf = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        block4: for (int i = 0; i < 8; ++i) {
            appBuf.clear();
            SSLEngineResult result = engine.unwrap(packetBuf, appBuf);
            switch (result.getHandshakeStatus()) {
                case NEED_UNWRAP: {
                    continue block4;
                }
                case NEED_TASK: {
                    engine.getDelegatedTask().run();
                    continue block4;
                }
            }
        }
    }

    private static void wrap(SSLEngine sslEngine, ByteBuffer packetBuf) throws SSLException {
        ByteBuffer appBuf = ByteBuffer.allocate(0);
        block4: for (int i = 0; i < 8; ++i) {
            SSLEngineResult result = sslEngine.wrap(appBuf, packetBuf);
            switch (result.getHandshakeStatus()) {
                case NEED_WRAP: {
                    continue block4;
                }
                case NEED_TASK: {
                    sslEngine.getDelegatedTask().run();
                    continue block4;
                }
            }
        }
    }

    private ServerSslContextUtil() {
    }
}

