/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.common.util.HttpTimestampSupplier;
import com.linecorp.armeria.server.Http1ServerKeepAliveHandler;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

final class ServerHttp1ObjectEncoder
extends Http1ObjectEncoder
implements ServerHttpObjectEncoder {
    private final KeepAliveHandler keepAliveHandler;
    private final boolean enableServerHeader;
    private final boolean enableDateHeader;
    private final Http1HeaderNaming http1HeaderNaming;
    private boolean shouldSendConnectionCloseHeader;
    private boolean sentConnectionCloseHeader;
    private int lastResponseHeadersId;

    ServerHttp1ObjectEncoder(Channel ch, SessionProtocol protocol, KeepAliveHandler keepAliveHandler, boolean enableDateHeader, boolean enableServerHeader, Http1HeaderNaming http1HeaderNaming) {
        super(ch, protocol);
        assert (keepAliveHandler instanceof Http1ServerKeepAliveHandler || keepAliveHandler instanceof NoopKeepAliveHandler);
        this.keepAliveHandler = keepAliveHandler;
        this.enableServerHeader = enableServerHeader;
        this.enableDateHeader = enableDateHeader;
        this.http1HeaderNaming = http1HeaderNaming;
    }

    @Override
    public KeepAliveHandler keepAliveHandler() {
        return this.keepAliveHandler;
    }

    public void initiateConnectionShutdown() {
        this.shouldSendConnectionCloseHeader = true;
    }

    @Override
    public ChannelFuture doWriteHeaders(int id, int streamId, ResponseHeaders headers, boolean endStream, boolean isTrailersEmpty) {
        if (!this.isWritable(id)) {
            return this.newClosedSessionFuture();
        }
        HttpResponse converted = this.convertHeaders(headers, endStream, isTrailersEmpty);
        if (headers.status().isInformational()) {
            return this.write(id, (HttpObject)converted, false);
        }
        this.lastResponseHeadersId = id;
        if (this.shouldSendConnectionCloseHeader || this.keepAliveHandler.needToCloseConnection()) {
            converted.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.sentConnectionCloseHeader = true;
        }
        return this.writeNonInformationalHeaders(id, (HttpObject)converted, endStream, this.channel().newPromise());
    }

    private HttpResponse convertHeaders(ResponseHeaders headers, boolean endStream, boolean isTrailersEmpty) {
        DefaultFullHttpResponse res;
        int statusCode = headers.status().code();
        HttpResponseStatus nettyStatus = HttpResponseStatus.valueOf((int)statusCode);
        if (headers.status().isInformational()) {
            res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.EMPTY_BUFFER, false);
            ArmeriaHttpUtil.toNettyHttp1ServerHeaders(headers, res.headers(), this.http1HeaderNaming);
        } else if (endStream) {
            res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, Unpooled.EMPTY_BUFFER, false);
            io.netty.handler.codec.http.HttpHeaders outHeaders = res.headers();
            this.convertHeaders((HttpHeaders)headers, outHeaders, isTrailersEmpty);
            if (HttpStatus.isContentAlwaysEmpty(statusCode)) {
                if (statusCode != 304) {
                    outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                }
            } else if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                outHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        } else {
            res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, nettyStatus, false);
            this.convertHeaders((HttpHeaders)headers, res.headers(), isTrailersEmpty);
            ServerHttp1ObjectEncoder.maybeSetTransferEncoding((HttpMessage)res);
        }
        return res;
    }

    private void convertHeaders(HttpHeaders inHeaders, io.netty.handler.codec.http.HttpHeaders outHeaders, boolean isTrailersEmpty) {
        ArmeriaHttpUtil.toNettyHttp1ServerHeaders(inHeaders, outHeaders, this.http1HeaderNaming);
        if (!isTrailersEmpty && outHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        if (this.enableServerHeader && !outHeaders.contains((CharSequence)HttpHeaderNames.SERVER)) {
            outHeaders.add((CharSequence)HttpHeaderNames.SERVER, (Object)ArmeriaHttpUtil.SERVER_HEADER);
        }
        if (this.enableDateHeader && !outHeaders.contains((CharSequence)HttpHeaderNames.DATE)) {
            outHeaders.add((CharSequence)HttpHeaderNames.DATE, (Object)HttpTimestampSupplier.currentTime());
        }
    }

    private static void maybeSetTransferEncoding(HttpMessage out) {
        io.netty.handler.codec.http.HttpHeaders outHeaders = out.headers();
        long contentLength = HttpUtil.getContentLength((HttpMessage)out, (long)-1L);
        if (contentLength < 0L) {
            outHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            outHeaders.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
    }

    @Override
    protected void convertTrailers(HttpHeaders inputHeaders, io.netty.handler.codec.http.HttpHeaders outputHeaders) {
        ArmeriaHttpUtil.toNettyHttp1ServerTrailers(inputHeaders, outputHeaders, this.http1HeaderNaming);
    }

    @Override
    protected boolean isPing(int id) {
        return false;
    }

    boolean isSentConnectionCloseHeader() {
        return this.sentConnectionCloseHeader;
    }

    @Override
    public boolean isResponseHeadersSent(int id, int streamId) {
        return id <= this.lastResponseHeadersId;
    }

    @Override
    public ChannelFuture writeErrorResponse(int id, int streamId, ServiceConfig serviceConfig, RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        this.keepAliveHandler().destroy();
        ChannelFuture future = ServerHttpObjectEncoder.super.writeErrorResponse(id, streamId, serviceConfig, headers, status, message, cause);
        this.updateClosedId(id);
        return future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

