/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Http1HeaderNaming;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.server.ClientAddressSource;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.VirtualHost;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface ServerConfig {
    public Server server();

    public List<ServerPort> ports();

    public VirtualHost defaultVirtualHost();

    public List<VirtualHost> virtualHosts();

    @Deprecated
    public VirtualHost findVirtualHost(String var1);

    public VirtualHost findVirtualHost(String var1, int var2);

    public List<VirtualHost> findVirtualHosts(HttpService var1);

    public List<ServiceConfig> serviceConfigs();

    public EventLoopGroup workerGroup();

    public boolean shutdownWorkerGroupOnStop();

    public Map<ChannelOption<?>, ?> channelOptions();

    public Map<ChannelOption<?>, ?> childChannelOptions();

    public int maxNumConnections();

    public long idleTimeoutMillis();

    public long pingIntervalMillis();

    public long maxConnectionAgeMillis();

    public long connectionDrainDurationMicros();

    public int maxNumRequestsPerConnection();

    public int http1MaxInitialLineLength();

    public int http1MaxHeaderSize();

    public int http1MaxChunkSize();

    public int http2InitialConnectionWindowSize();

    public int http2InitialStreamWindowSize();

    public long http2MaxStreamsPerConnection();

    public int http2MaxFrameSize();

    public long http2MaxHeaderListSize();

    public Duration gracefulShutdownQuietPeriod();

    public Duration gracefulShutdownTimeout();

    public ScheduledExecutorService blockingTaskExecutor();

    public boolean shutdownBlockingTaskExecutorOnStop();

    public MeterRegistry meterRegistry();

    public int proxyProtocolMaxTlvSize();

    public List<ClientAddressSource> clientAddressSources();

    public Predicate<? super InetAddress> clientAddressTrustedProxyFilter();

    public Predicate<? super InetAddress> clientAddressFilter();

    public Function<? super ProxiedAddresses, ? extends InetSocketAddress> clientAddressMapper();

    public boolean isDateHeaderEnabled();

    public boolean isServerHeaderEnabled();

    public Supplier<RequestId> requestIdGenerator();

    public ServerErrorHandler errorHandler();

    public Http1HeaderNaming http1HeaderNaming();
}

